/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.javascript.JSBuiltInTypeEngineEvaluation;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSPropertyNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.typescript.TSSymbolDeclaration;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPropertyNameReference
implements PsiPolyVariantReference {
    @NotNull
    private final JSProperty myProperty;
    @NotNull
    private final String myPropertyName;

    public JSPropertyNameReference(@NotNull JSProperty property, @NotNull String propertyName) {
        if (property == null) {
            JSPropertyNameReference.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            JSPropertyNameReference.$$$reportNull$$$0(1);
        }
        this.myProperty = property;
        this.myPropertyName = propertyName;
    }

    @NotNull
    public JSProperty getElement() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            JSPropertyNameReference.$$$reportNull$$$0(2);
        }
        return jSProperty;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement nameIdentifier = this.myProperty.getNameIdentifier();
        if (nameIdentifier == null) {
            TextRange textRange = this.myProperty.getTextRange();
            if (textRange == null) {
                JSPropertyNameReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int quotesDelta = nameIdentifier.getNode().getElementType() == JSTokenTypes.STRING_LITERAL && nameIdentifier.getTextLength() >= 2 ? 1 : 0;
        int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
        return new TextRange(startOffsetInParent + quotesDelta, startOffsetInParent + nameIdentifier.getTextLength() - quotesDelta);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length != 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!this.myProperty.isValid()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPropertyNameReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiReference[] nameRefs = this.myProperty.getNameIdentifier() != null ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myProperty.getNameIdentifier()) : EMPTY_ARRAY;
        ResolveResult[] results = (ResolveResult[])JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)this.myProperty.getContainingFile(), () -> JSResolveUtil.resolve(this.myProperty.getContainingFile(), this, JSPropertyNameResolver.INSTANCE, incompleteCode));
        ResolveResult[] resolveResultArray = this.merge(results, nameRefs, incompleteCode);
        if (resolveResultArray == null) {
            JSPropertyNameReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private ResolveResult[] merge(ResolveResult[] resolves, PsiReference[] refs, boolean incompleteCode) {
        if (refs.length == 0) {
            return resolves;
        }
        ArrayList<ResolveResult> list = new ArrayList<ResolveResult>();
        for (ResolveResult resolveResult : resolves) {
            if (resolveResult.getElement() == this.myProperty) continue;
            list.add(resolveResult);
        }
        for (ResolveResult resolveResult : refs) {
            if (resolveResult instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference polyRef = (PsiPolyVariantReference)resolveResult;
                ResolveResult[] results = polyRef.multiResolve(incompleteCode);
                list.addAll(Arrays.asList(results));
                continue;
            }
            PsiElement resolve = resolveResult.resolve();
            if (resolve == null || !resolve.isValid()) continue;
            list.add(new JSResolveResult(resolve));
        }
        return list.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myPropertyName;
        if (string == null) {
            JSPropertyNameReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSPropertyNameReference.$$$reportNull$$$0(7);
        }
        this.myProperty.setName(newElementName);
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    private List<PsiElement> resolveAndUnwrapMergedTypeMembers() {
        ResolveResult[] elements;
        PsiElement resolvedElement = this.resolve();
        if (resolvedElement instanceof TypeScriptProxyImplicitElement) {
            TypeScriptProxyImplicitElement proxyImplicitElement = (TypeScriptProxyImplicitElement)resolvedElement;
            List list = ContainerUtil.createMaybeSingletonList((Object)proxyImplicitElement.getExplicitElement());
            if (list == null) {
                JSPropertyNameReference.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (resolvedElement instanceof TSSymbolDeclaration) {
            TSSymbolDeclaration symbolDeclaration = (TSSymbolDeclaration)resolvedElement;
            List list = ContainerUtil.createMaybeSingletonList((Object)symbolDeclaration.getExplicitElement());
            if (list == null) {
                JSPropertyNameReference.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (resolvedElement != null) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolvedElement);
            if (list == null) {
                JSPropertyNameReference.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<PsiElement> allElements = new ArrayList<PsiElement>();
        for (ResolveResult result : elements = this.multiResolve(false)) {
            TSSymbolDeclaration symbolDeclaration;
            TypeScriptProxyImplicitElement proxyImplicitElement;
            PsiElement explicitElement;
            PsiElement resultElement = result.getElement();
            if (resultElement instanceof TypeScriptProxyImplicitElement && !allElements.contains(explicitElement = (proxyImplicitElement = (TypeScriptProxyImplicitElement)resultElement).getExplicitElement())) {
                allElements.add(explicitElement);
            }
            if (!(resultElement instanceof TSSymbolDeclaration) || allElements.contains(explicitElement = (symbolDeclaration = (TSSymbolDeclaration)resultElement).getExplicitElement())) continue;
            allElements.add(explicitElement);
        }
        ArrayList<PsiElement> arrayList = allElements;
        if (arrayList == null) {
            JSPropertyNameReference.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(13);
        }
        return (Boolean)JSBuiltInTypeEngineEvaluation.forceBuiltInTypeEngineIfNeeded((PsiElement)this.myProperty, element, () -> this.isReferenceToImpl(element));
    }

    private boolean isReferenceToImpl(@NotNull PsiElement element) {
        JSDefinitionExpression def;
        Object object;
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(14);
        }
        if (element instanceof TypeScriptProxyImplicitElement) {
            TypeScriptProxyImplicitElement proxyImplicitElement = (TypeScriptProxyImplicitElement)element;
            PsiElement explicitElement = proxyImplicitElement.getExplicitElement();
            return this.isReferenceTo(explicitElement);
        }
        if (element instanceof TSSymbolDeclaration) {
            TSSymbolDeclaration symbolDeclaration = (TSSymbolDeclaration)element;
            return this.isReferenceTo(symbolDeclaration.getExplicitElement());
        }
        if (element instanceof TypeScriptField || element instanceof TypeScriptFunction) {
            JSClass refElementClass = JSUtils.getMemberContainingClass(element);
            if (refElementClass != null) {
                List<PsiElement> resolvedElements = this.resolveAndUnwrapMergedTypeMembers();
                for (PsiElement el : resolvedElements) {
                    JSPsiElementBase jsElement;
                    if (el == element) {
                        return true;
                    }
                    JSClass resolvedElementClass = JSUtils.getMemberContainingClass(el);
                    if (resolvedElementClass == null || !(el instanceof JSPsiElementBase) || !JSInheritanceUtil.checkMemberHierarchyIncludeClass(jsElement = (JSPsiElementBase)el, refElementClass)) continue;
                    return true;
                }
                return false;
            }
            if (element instanceof TypeScriptPropertySignature || element instanceof TypeScriptFunctionSignature) {
                return ContainerUtil.exists(this.resolveAndUnwrapMergedTypeMembers(), e -> e == element);
            }
        }
        if (element instanceof JSDefinitionExpression && (object = (def = (JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression) {
            JSReferenceExpression ref = (JSReferenceExpression)object;
            return ContainerUtil.exists(this.resolveAndUnwrapMergedTypeMembers(), e -> ref.isReferenceTo((PsiElement)e));
        }
        if (element instanceof JSProperty) {
            JSProperty elementAsProperty = (JSProperty)element;
            List<PsiElement> propertyResolvedElements = this.resolveAndUnwrapMergedTypeMembers();
            if (element != this.myProperty && propertyResolvedElements.contains(element)) {
                return true;
            }
            for (PsiElement element2 : propertyResolvedElements) {
                if (element == element2 || !(element2 instanceof JSPsiElementBase)) continue;
                JSPsiElementBase element2AsNamed = (JSPsiElementBase)element2;
                if (!StringUtil.equals((CharSequence)elementAsProperty.getName(), (CharSequence)element2AsNamed.getName()) || !JSSymbolUtil.canElementsBeFromSameNamespace(elementAsProperty, element2AsNamed)) continue;
                return true;
            }
        }
        if (element instanceof JSImplicitElement) {
            return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.getCanonicalText(), element);
        }
        return false;
    }

    public Object @NotNull [] getVariants() {
        PsiElement identifier = this.myProperty.getNameIdentifier();
        if (identifier == null) {
            if (EMPTY_ARRAY == null) {
                JSPropertyNameReference.$$$reportNull$$$0(15);
            }
            return EMPTY_ARRAY;
        }
        PsiReference[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)identifier);
        ArrayList<Object> list = new ArrayList<Object>();
        for (PsiReference reference : references) {
            Object[] variants = reference.getVariants();
            if (variants.length <= 0) continue;
            list.addAll(Arrays.asList(variants));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list);
        if (objectArray == null) {
            JSPropertyNameReference.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 9, 10, 11, 12, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndUnwrapMergedTypeMembers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 9, 10, 11, 12, 15, 16 -> new IllegalStateException(string);
        };
    }
}

