/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.StubIndexSupport;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSArgumentListImpl;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSAmdPsiUtil {
    @ApiStatus.Internal
    public static final String DEFINE_CALL_LOCAL_ALIAS_KEY = "def";
    @ApiStatus.Internal
    public static final String AMD_MODULE_NAME_MARK = "amd";
    @ApiStatus.Internal
    public static final String DEFAULT_FILE_MODULE_KEY = "";
    private static final TokenSet CALL_EXPRESSION_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.CALL_EXPRESSION});
    private static final TokenSet STOP_AT_WHEN_SEARCHING_DEFINE_TOKEN_SET = TokenSet.andNot((TokenSet)JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.EXPRESSION_STATEMENT}));

    @Nullable
    public static PsiElement findReferencedModule(@NotNull JSParameter amdModuleParameter) {
        JSLiteralExpression amdModuleReference;
        if (amdModuleParameter == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(0);
        }
        if ((amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(amdModuleParameter)) == null) {
            return null;
        }
        PsiReference[] references = amdModuleReference.getReferences();
        if (references.length == 0) {
            return null;
        }
        Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)amdModuleParameter, references);
        for (PsiElement resolve : modules) {
            if (!(resolve instanceof JSFile)) continue;
            List<PsiElement> callExpressionStatements = JSStubBasedPsiTreeUtil.findDescendants(resolve, CALL_EXPRESSION_TOKEN_SET, STOP_AT_WHEN_SEARCHING_DEFINE_TOKEN_SET);
            for (PsiElement statement : callExpressionStatements) {
                List descendants;
                assert (statement instanceof JSCallExpression);
                JSElementIndexingData indexingData = ((JSCallExpression)statement).getIndexingData();
                Map<String, String> userStrings = indexingData != null ? indexingData.getUserStrings() : null;
                String localAlias = userStrings != null ? userStrings.get(DEFINE_CALL_LOCAL_ALIAS_KEY) : null;
                if (localAlias == null || (descendants = JSStubBasedPsiTreeUtil.findDescendants(statement, JSElementTypes.FUNCTION_EXPRESSIONS, JSElementTypes.FUNCTION_EXPRESSIONS)).size() != 1) continue;
                PsiElement functionExpression = (PsiElement)descendants.iterator().next();
                assert (functionExpression instanceof JSFunctionExpression);
                if (!localAlias.isEmpty()) {
                    return JSStubBasedPsiTreeUtil.resolveLocally(localAlias, functionExpression);
                }
                Collection expressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunctionExpression)functionExpression, JSFunctionExpression.class);
                if (expressions.isEmpty()) continue;
                return (PsiElement)ContainerUtil.getFirstItem(expressions);
            }
        }
        return null;
    }

    public static boolean isDefineCall(@NotNull JSCallExpression node) {
        if (node == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(1);
        }
        return JSAmdPsiUtil.isDefineCall(node.getNode());
    }

    public static boolean isDefineCall(@NotNull ASTNode callNode) {
        String name;
        ASTNode methodExpression;
        if (callNode == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(2);
        }
        if ((methodExpression = JSCallExpressionImpl.getMethodExpression(callNode)) != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(methodExpression) == null && ("define".equals(name = JSReferenceExpressionImpl.getReferenceName(methodExpression)) || "require".equals(name))) {
            return JSAmdPsiUtil.getModuleInitializer(callNode) != null;
        }
        return false;
    }

    @Nullable
    public static JSExpression getModuleInitializer(@NotNull JSCallExpression defineCall) {
        ASTNode moduleInitializer;
        if (defineCall == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(3);
        }
        return (moduleInitializer = JSAmdPsiUtil.getModuleInitializer(defineCall.getNode())) != null ? (JSExpression)moduleInitializer.getPsi() : null;
    }

    @Nullable
    private static ASTNode getModuleInitializer(@NotNull ASTNode callExpressionNode) {
        ASTNode argumentList;
        if (callExpressionNode == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(4);
        }
        if ((argumentList = JSCallExpressionImpl.getArgumentList(callExpressionNode)) == null) {
            return null;
        }
        ASTNode[] arguments = JSArgumentListImpl.getArguments(argumentList);
        ASTNode candidate = null;
        if (arguments.length == 1) {
            candidate = arguments[0];
        } else if (arguments.length == 2 && (arguments[0].getElementType() == JSElementTypes.ARRAY_LITERAL_EXPRESSION || JSLiteralExpressionImpl.isQuotedLiteral(arguments[0]))) {
            candidate = arguments[1];
        } else if (arguments.length == 3 && JSLiteralExpressionImpl.isQuotedLiteral(arguments[0]) && arguments[1].getElementType() == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            candidate = arguments[2];
        }
        return candidate != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(candidate.getElementType()) ? candidate : null;
    }

    @NotNull
    public static String unifyModuleName(@NotNull JSLiteralExpression literalExpression) {
        String value;
        if (literalExpression == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(5);
        }
        if ((value = literalExpression.getSignificantValue()) == null) {
            value = literalExpression.getText();
        }
        String string = CommonJSUtil.unifyModuleName(value);
        if (string == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static JSQualifiedName getNamespaceForAmdModuleElements(@NotNull JSFunction initializer) {
        Pair<JSLiteralExpression, JSArrayLiteralExpression> requireArguments;
        if (initializer == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(7);
        }
        if ((requireArguments = JSAmdPsiUtil.getRequireArguments(initializer)) != null) {
            String name = requireArguments.first != null ? JSAmdPsiUtil.unifyModuleName((JSLiteralExpression)requireArguments.first) : "exports";
            return JSQualifiedNameImpl.create(name, null);
        }
        return null;
    }

    @Nullable
    public static String getNamespaceFromExplicitModuleName(@NotNull JSCallExpression defineCall) {
        JSLiteralExpression explicitName;
        if (defineCall == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(8);
        }
        if ((explicitName = JSAmdPsiUtil.getExplicitModuleNameLiteral(defineCall)) != null) {
            return JSAmdPsiUtil.unifyModuleName(explicitName);
        }
        return null;
    }

    @Nullable
    public static String getExplicitModuleName(@NotNull JSCallExpression defineCall) {
        String name;
        if (defineCall == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(9);
        }
        return (name = JSAmdPsiUtil.getNamespaceFromExplicitModuleName(defineCall)) != null ? StringUtil.trimStart((String)name, (String)"module:") : null;
    }

    @Nullable
    private static JSLiteralExpression getExplicitModuleNameLiteral(@NotNull JSCallExpression defineCall) {
        if (defineCall == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(10);
        }
        assert (defineCall instanceof StubBasedPsiElementBase);
        StubElement stub = ((StubBasedPsiElementBase)defineCall).getStub();
        JSLiteralExpression explicitName = null;
        if (stub == null) {
            JSExpression[] arguments = defineCall.getArguments();
            if (arguments[0] instanceof JSLiteralExpression) {
                explicitName = (JSLiteralExpression)arguments[0];
            }
        } else {
            StubElement firstChild;
            PsiElement psi;
            List stubs = stub.getChildrenStubs();
            if (!stubs.isEmpty() && (psi = (firstChild = (StubElement)stubs.get(0)).getPsi()) instanceof JSLiteralExpression) {
                explicitName = (JSLiteralExpression)psi;
            }
        }
        return explicitName;
    }

    @Nullable
    public static Pair<JSLiteralExpression, JSArrayLiteralExpression> getRequireArguments(@NotNull JSFunction function) {
        PsiElement parent;
        PsiElement grandParent;
        if (function == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(11);
        }
        PsiElement psiElement = grandParent = (parent = function.getParent()) instanceof JSArgumentList ? parent.getParent() : null;
        if (grandParent instanceof JSCallExpression && JSAmdPsiUtil.isDefineCall((JSCallExpression)grandParent)) {
            JSLiteralExpression moduleName = null;
            JSArrayLiteralExpression deps = null;
            JSExpression[] arguments = ((JSCallExpression)grandParent).getArguments();
            if (arguments[0] instanceof JSLiteralExpression) {
                moduleName = (JSLiteralExpression)arguments[0];
            }
            if (moduleName == null && arguments[0] instanceof JSArrayLiteralExpression) {
                deps = (JSArrayLiteralExpression)arguments[0];
            } else if (moduleName != null && arguments[1] instanceof JSArrayLiteralExpression) {
                deps = (JSArrayLiteralExpression)arguments[1];
            }
            return Pair.create((Object)moduleName, deps);
        }
        return null;
    }

    public static boolean isWithinAmdModule(@NotNull PsiElement element) {
        if (element == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(12);
        }
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSCallExpression.class});
        while (callExpression != null) {
            if (callExpression.isDefineCall()) {
                return true;
            }
            callExpression = (JSCallExpression)PsiTreeUtil.getContextOfType((PsiElement)callExpression, (Class[])new Class[]{JSCallExpression.class});
        }
        return false;
    }

    @Nullable
    public static JSFunctionExpression findDefaultAmdModule(@NotNull JSFile file) {
        if (file == null) {
            JSAmdPsiUtil.$$$reportNull$$$0(13);
        }
        Collection<JSFunctionExpression> elements = StubIndexSupport.getInstance().getElements(JSIndexKeys.JS_AMD_MODULES_INDEX_KEY, DEFAULT_FILE_MODULE_KEY, file.getProject(), GlobalSearchScope.fileScope((PsiFile)file), JSFunctionExpression.class);
        return (JSFunctionExpression)ContainerUtil.getFirstItem(elements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdModuleParameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callNode";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defineCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdPsiUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDefineCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInitializer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unifyModuleName";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceForAmdModuleElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromExplicitModuleName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitModuleNameLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRequireArguments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWithinAmdModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultAmdModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

