/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.database.Dbms;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlTokens;

public class MysqlGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static boolean isMariaDialect(PsiBuilder builder, int level) {
        return MysqlGeneratedParserUtil.getParser((PsiBuilder)builder).getLanguage().getDbms() == Dbms.MARIA;
    }

    public static boolean afterIsAs(PsiBuilder builder, int level) {
        int i = -1;
        IElementType type = builder.rawLookup(i);
        while (type != null && SqlTokens.WS_OR_COMMENTS.contains(type)) {
            type = builder.rawLookup(--i);
        }
        if (type == null) {
            PsiElement element = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder);
            while (element != null && SqlTokens.WS_OR_COMMENTS.contains(type = PsiUtilCore.getElementType((PsiElement)(element = element.getPrevSibling())))) {
            }
        }
        return type == MysqlReservedKeywords.MYSQL_AS || type == MysqlReservedKeywords.MYSQL_IS;
    }

    public static boolean parseUuidSet(PsiBuilder builder, int level) {
        MysqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<uuid set>");
        if (!MysqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)MysqlTokens.MYSQL_UUID_SET)) {
            return false;
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        mark.done((IElementType)SqlCompositeElementTypes.SQL_SPECIAL_LITERAL);
        return true;
    }

    public static boolean isAtDelimiter(PsiBuilder builder, int level) {
        return MysqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN, SqlCommonTokens.SQL_SEMICOLON});
    }
}

