\page Exampletransforms Example transforms

 This example illustrates various ways to place a volume.

 There are two G4PVPlacement constructors. One uses a direct rotation matrix,
 via G4Transform3D class. The other uses an inverse rotation matrix.
 The rotation matrices themselves, direct or inverse, can be explicitely computed
 by users, or built with various G4 build-in transformations methods,
 like axial rotations.

## Geometry construction

 Two G4Trd volumes (daughters) are placed within a G4Tubs (mother), in such a way
 that their z_axis are in the mother xy plane.
 To see the picture, run the example in interactive mode.

 The various ways of placement are implemented in the DetectorConstruction class
 in the following private functions:

 - DetectorConstruction::PlaceWithDirectMatrix() \n
   This method is using G4PVPlacement with G4Transform3D, which is constructed from a rotation matrix (G4RotationMatrix) and a translation vector (G4ThreeVector). The rotation and translation in this case represent the active transformation: the solid itself is moved by rotating and translating it to bring it into the system of coordinates of the mother volume.\n
   The rotation matrix is defined via the daughter frame axes with respect to the mother frame.\n\n

 - DetectorConstruction::PlaceWithInverseMatrix() \n
   This method is using G4PVPlacement with a rotation matrix (G4RotationMatrix) and a translation vector (G4ThreeVector). The rotation Matrix represents the rotation of the reference frame of the considered volume relatively to its mother volume’s reference frame. The translation Vector represents the translation of the current volume in the reference frame of its mother volume.  \n
   If compared to the previous construct, the transformation in this case is generated by specifying the same translation with respect to its mother volume and the inverse of the rotation matrix.  \n
   The rotation matrix is defined again via the daughter frame axes with respect to the mother frame. \n\n

 - DetectorConstruction::PlaceWithAxialRotations() \n
   This method is using G4PVPlacement with G4Transform3D again, but in difference from
   PlaceWithDirectMatrix(), the rotation matrix is defined via rotate[X,Y,Z]() member functions of G4RotationMatrix. \n\n

 - DetectorConstruction::PlaceWithEulerAngles() \n
   This method is using G4PVPlacement with G4Transform3D again, but with the rotation matrix is defined via Euler angles. \n\n

 - DetectorConstruction::PlaceWithReflections() \n
   In this method, in addition to two positions defined via "PlaceWithAxialRotations" method, two more positions including reflection symmetry are defined.
   When reflections are present in geometry, the placements have to be applied
   via G4ReflectionFactory::Place() method, where a G4Transform3D with reflection
   can be used.

 These functions are then called from the DetectorConstruction::Construct() function.
 All methods define exactly same geometry except for the placement
 with reflection where trapezoids are placed with their symmetry axis
 in parallel with z-axis in order to make easier to check reflection
 visually.

 The method of placement can be selected interactively via the command
 (see DetectorMessenger and transforms.in):
```
/placement/setMethod method
   where method = WithDirectMatrix, WithInverseMatrix, WithAxialRotations,
                  WithEulerAngles, WithReflections
```

## Physics list

 PhysicsList.cc defines only geantino and transportation process.

## Primary generator

 Default kinematic is a geantino, at coordinate origin.
 Can be changed with particleGun commands.

## Physics

 No physics; only transportation.

## Visualisation

 In interactive mode, visualization manager is set in the main().
 Initialisation of the drawing is done via the commands
 `/vis/..`` in the macro vis.mac.

## How to start ?

  - Execute transforms in 'interactive mode' with visualization
```
% ./transforms
....
Idle>   ---> type your commands. For instance:
Idle> /placement/setMethod WithInverseMatrix
Idle> /control/execute vis.mac
Idle> /tracking/verbose 1
Idle> /run/beamOn 1
Idle> exit
```
 or, simply
```
Idle> /control/execute rotations.mac
Idle> /control/execute reflections.mac
```

  - Execute transforms in 'batch' mode from macro files
```
% transforms transforms.in
```

