\page ExampleHepMCEx01 Example HepMCEx01

 HepMCEx01 is based on Example N04, which has a simplified collider detector
geometry. Only part of the primary generator action is replaced with new one.
This example demonstrates the following features.

## HepMC interface

 ExN04PrimaryGeneratorAction has HepMCG4Interface as the generator.
There are two types of generators provided as samples. One generator reads
primary information from a HepMC Ascii file (data/example_MyPythia.dat).
The other one generates primaries directly invoking PYTHIA routines
in every event.

## Readout geometry

 ExN04DetectorConstruction defines a simplified collider detecor
geometry, tracker made of cylindrical tubes, calorimeter made of
cylindrical tubes, and muon trackers made of planes.
 Cylindrical calorimeter is made of tubes of lead and scintirator
without cut in phi nor z direction. Energy deposition in scintirator
is accumulated by ExN04CalorimeterSD sensitive detector, which has
a readout geometry to find the phi-z cell.

## Full set of "ordinary" physics processes

FTFP_BERT physics list defines almost all of leptons and hadrons which
Geant4 has dedicated classes for. Also almost all physics processes
Geant4 has are defined.

## Event filtering by the stacking mechanism.

 Higgs events in "pythia_event.data" have two lepton pairs produced
by the Higgs decay via Z0. At the first stage of each event, only the
primary muons are tracked without tracking secondaries. then the number
of hits on the muon trackers are examined. At the next stage, only
the primary charged particles are tracked only inside the barrel
tracking area and the isolation of the primary muons are examined.
At the third stage, all particles in the RoI (Region of Interest) along
the isolated muons are tracked. All these examinations are applied in
ExN04StackingAction.

## Installation

 See ["eventgenerator/HepMC" page](../../html/Examples_HepMC.html) how to build this example.

## Execution
```
% ./HepMCEx01 hepmc_pygen.in
```
