\page ExampleTestEm1 Example TestEm1

  - How to count processes.
  - How to activate/inactivate processes.
  - How to survey the tracking, in particular the range of charged particles.
  - How to define a maximum step size.
	
## GEOMETRY DEFINITION
 
  It is a simple box which represents a 'semi infinite' homogeneous medium.
 	
  Two parameters define the geometry :
   - the material of the box,
   - the full size of the box.
	 	
  In addition a transverse uniform magnetic field can be applied.
 	
  The default geometry is constructed in DetectorConstruction class, but all of 
  the above parameters can be changed interactively via the commands defined in 
  the DetectorMessenger class.
 	
## PHYSICS LIST

  Physics lists are based on modular design. Several modules are instantiated:
  1. Transportation
  2. EM physics
  3. Decays
  4. StepMax - for step limitation

  EM physics builders can be local (eg. in this example) or from G4 kernel
  physics_lists subdirectory.

  Local physics builder:	 
   - "local"	  standard EM physics with current 'best' options setting.
                  these options are explicited in PhysListEmStandard
    
  From geant4/source/physics_lists/builders:	 
   - "emstandard_opt0" recommended standard EM physics for LHC
   - "emstandard_opt1" best CPU performance standard physics for LHC
   - "emstandard_opt2" similar fast simulation
   - "emstandard_opt3" best standard EM options - analog to "local" above
   - "emstandard_opt4" best current advanced EM options standard + lowenergy
   - "emstandardSS"  standard EM physics and single scattering model
   - "emlivermore"  low-energy EM physics using Livermore data
   - "empenelope"   low-energy EM physics implementing Penelope models
   - "emlowenergy"  low-energy EM physics implementing experimental
                    low-energy models
             
  Physics lists and options can be (re)set with UI commands
    
  A few commands have been added to PhysicsList, in order to set the production
  threshold for secondaries for gamma and e-/e+.
  
## AN EVENT : THE PRIMARY GENERATOR
 
  The primary kinematic consists of a single particle starting at the left face 
  of the box. The type of the particle and its energy are set in the 
  PrimaryGeneratorAction class, and can be changed via the G4 build-in commands 
  of G4ParticleGun class (see the macros provided with this example).
	
  In addition one can choose randomly the impact point of the incident particle.
  The corresponding interactive command is built in PrimaryGeneratorMessenger.	
 				
## VISUALIZATION
 
  The Visualization Manager is set in the main().
  The initialisation of the drawing is done via the commands /vis/... in the 
  macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```
 	
  The detector has a default view which is a longitudinal view of the box.
 	
  The tracks are drawn at the end of event, and erased at the end of run.
 	
## PHYSICS SURVEY
 
  The particle's type and the physics processes which will be available in this 
  example are set in PhysicsList class.
 	
  A set of macros defining various run conditions are provided. The processes 
  are actived/inactivated together with differents cuts, in order to survey the
  processes one by one.

  The number of produced secondaries are counted, the number of steps, and the 
  number of process calls responsible of the step.
 	
## HOW TO START ?
 
  - Execute TestEm1 in 'batch' mode from macro files
```
% ./TestEm1   runs.mac
```
 		
  - Execute TestEm1 in 'interactive mode' with visualization
```
% ./TestEm1
....
Idle> type your commands
....
Idle> exit
```

  Macros provided in this example:
  - brems.mac: Bremsstrahlung only
  - erange.mac: compute the csda range of primary particle
  - geantino.mac: geantino as primary particle
  - ionis.mac: Ionisation only
  - photoelec.mac: 100 keV photon photoelectric effect
  - radioactive.mac: use radioactive ion as primary particle
  - range.mac: compute the csda range of the primary particle
               with or without fluctuations
  - erange.mac, pRange.mac, alphaRange.mac, ionRange.mac: variants of range.mac
               to play with StepFunction()	       	       
  - runs.mac: electron 100 MeV; all processes

  Macros to be run interactively:
  - annihil.mac: To visualise 100 MeV e+ annihilation
  - decayinfly.mac: To visualise decay in fly of N16
  - etaDecay.mac: to visualise decay of eta particle
  - gammaconversion.mac: To visualise gamma conversion and e+ annihilation
  - photon.mac: To visualiza p300 keV photon beam
  - stepMax.mac: to test command /testem/stepMax
  - vis.mac: To activate visualization

## TRACKING : StepMax
 
  In order to control the accuracy of the deposition, the user can limit
  'by hand' the maximum  step size of charged particles.
  As an example, this limitation is implemented as a 'full' process :
  see StepMax class and its Messenger. The 'StepMax process' is registered
  in the Physics List. 
  	
## HISTOGRAMS
 
  Testem1 produces several histo which are saved as testem1.root by default.
  Content of these histo:  
      - 1 : track length of primary particle
      - 2 : number of steps primary particle
      - 3 : step size of primary particle
      - 4 : total energy deposit
      - 5 : energy of charged secondaries at creation
      - 6 : energy of neutral secondaries at creation
      - 7 : NIEL energy
      - 8 : energy leakage
      - 9 : energy deposit + leakage
      
   The histograms are managed by G4AnalysisManager class and its Messenger. 
   The histos can be individually activated with the command :
   /analysis/h1/set id nbBins  valMin valMax unit 
   where unit is the desired unit for the histo (MeV or keV, deg or mrad, etc..)
   
   One can control the name of the histograms file with the command:
```
   /analysis/setFileName  name  (default testem1)
```
   
   It is possible to choose the format of the histogram file : root (default),
   hdf5, xml, csv, by changing the default file type in HistoManager.cc
     
   It is also possible to print selected histograms on an ascii file:
   /analysis/h1/setAscii id
   All selected histos will be written on a file name.ascii  (default testem1)
