/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ops4j.pax.web.extender.whiteboard.internal.BundleWhiteboardApplication;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.events.WebContextEventListener;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;
import org.ops4j.pax.web.service.spi.util.WebContainerListener;
import org.ops4j.pax.web.service.spi.util.WebContainerManager;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhiteboardExtenderContext
implements WebContainerListener,
WebContextEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(WhiteboardExtenderContext.class);
    final AtomicBoolean acceptWabContexts = new AtomicBoolean(false);
    private final Bundle bundle;
    private final WebContainerManager webContainerManager;
    private ServiceReference<WebContainer> currentWebContainerReference;
    private final Map<Bundle, BundleWhiteboardApplication> bundleApplications = new HashMap<Bundle, BundleWhiteboardApplication>();
    private final Lock lock = new ReentrantLock();
    private final Map<String, TreeSet<OsgiContextModel>> osgiContexts = new ConcurrentHashMap<String, TreeSet<OsgiContextModel>>();
    private final List<OsgiContextModel> osgiContextsList = new ArrayList<OsgiContextModel>();
    private AtomicBoolean defaultContextRegistered = new AtomicBoolean(false);
    private final ExecutorService executor;

    public WhiteboardExtenderContext(BundleContext bundleContext) {
        this(bundleContext, false);
    }

    public WhiteboardExtenderContext(BundleContext bundleContext, boolean synchronous) {
        this.bundle = bundleContext.getBundle();
        OsgiContextModel model = OsgiContextModel.DEFAULT_CONTEXT_MODEL;
        Bundle owner = FrameworkUtil.getBundle(this.getClass());
        if (owner != null) {
            model.setOwnerBundle(FrameworkUtil.getBundle(this.getClass()));
        }
        this.osgiContexts.computeIfAbsent(model.getName(), n -> new TreeSet()).add(model);
        this.osgiContextsList.add(model);
        this.webContainerManager = synchronous ? new WebContainerManager(bundleContext, (WebContainerListener)this) : new WebContainerManager(bundleContext, (WebContainerListener)this, "HttpService->Whiteboard");
        this.webContainerManager.initialize();
        this.executor = this.localThreadExecutor();
    }

    private ExecutorService localThreadExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            ThreadFactory tf = Executors.defaultThreadFactory();
            Thread thread = tf.newThread(r);
            thread.setName("Whiteboard Configuration Task");
            return thread;
        });
    }

    public void webContainerChanged(ServiceReference<WebContainer> oldReference, ServiceReference<WebContainer> newReference) {
        if (oldReference != null) {
            this.webContainerRemoved(oldReference);
        }
        if (newReference != null) {
            this.webContainerAdded(newReference);
        }
    }

    public void bundleStopped(Bundle bundle) {
        BundleWhiteboardApplication application;
        this.lock.lock();
        try {
            application = this.bundleApplications.remove(bundle);
        }
        finally {
            this.lock.unlock();
        }
        if (application != null) {
            LOG.debug("Clearing Whiteboard cache for {}", (Object)bundle);
            application.cleanup();
        }
    }

    public void wabContextRegistered(OsgiContextModel model) {
        if (!this.acceptWabContexts.get()) {
            return;
        }
        this.executor.execute(() -> {
            this.lock.lock();
            try {
                this.reRegisterWebElements();
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public void wabContextUnregistered(OsgiContextModel model) {
        if (!this.acceptWabContexts.get()) {
            return;
        }
        this.executor.execute(() -> {
            this.lock.lock();
            try {
                this.reRegisterWebElements();
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public void setExecutor(Executor executor) {
    }

    public void shutdown() {
        this.executor.shutdown();
        this.webContainerManager.shutdown();
        this.currentWebContainerReference = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OsgiContextModel> resolveContexts(Bundle bundle, Filter selector) {
        if (bundle == null) {
            return Collections.emptyList();
        }
        this.lock.lock();
        try {
            if (selector == null) {
                OsgiContextModel defaultModel = this.osgiContexts.get("default").iterator().next();
                List<OsgiContextModel> list = Collections.singletonList(defaultModel);
                return list;
            }
            ArrayList<Object> targetContexts = new ArrayList<Object>();
            for (OsgiContextModel model : this.osgiContextsList) {
                BundleWhiteboardApplication bundleWhiteboardApplication = this.getBundleApplication(model.getOwnerBundle());
                if (OsgiContextModel.DEFAULT_CONTEXT_MODEL.equals((Object)model) && !this.defaultContextRegistered.get() || !OsgiContextModel.DEFAULT_CONTEXT_MODEL.equals((Object)model) && (bundleWhiteboardApplication == null || !bundleWhiteboardApplication.isRegistered(model)) || !selector.matchCase((Dictionary)model.getContextRegistrationProperties())) continue;
                targetContexts.add(model);
            }
            for (OsgiContextModel model : this.getBundleApplication(bundle).getWebContainerOsgiContextModels()) {
                if (model.isShared() && !model.isWab() || !selector.matchCase((Dictionary)model.getContextRegistrationProperties())) continue;
                targetContexts.add(model);
            }
            HashMap<String, OsgiContextModel> uniqueContexts = new HashMap<String, OsgiContextModel>();
            for (OsgiContextModel osgiContextModel : targetContexts) {
                if (uniqueContexts.containsKey(osgiContextModel.getName()) && ((OsgiContextModel)uniqueContexts.get(osgiContextModel.getName())).compareTo(osgiContextModel) <= 0) continue;
                uniqueContexts.put(osgiContextModel.getName(), osgiContextModel);
            }
            targetContexts.clear();
            targetContexts.addAll(uniqueContexts.values());
            ArrayList<Object> arrayList = targetContexts;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void webContainerAdded(ServiceReference<WebContainer> ref) {
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, ref);
        if (view != null) {
            view.addWhiteboardOsgiContextModel(OsgiContextModel.DEFAULT_CONTEXT_MODEL);
            this.defaultContextRegistered.set(true);
            view.registerWabOsgiContextListener((WebContextEventListener)this);
        }
        this.currentWebContainerReference = ref;
        this.installWhiteboardApplications(ref);
        this.lock.lock();
        try {
            this.reRegisterWebElements();
        }
        finally {
            this.lock.unlock();
        }
        this.acceptWabContexts.set(true);
    }

    public void webContainerRemoved(ServiceReference<WebContainer> ref) {
        this.acceptWabContexts.set(false);
        this.currentWebContainerReference = null;
        this.uninstallWhiteboardApplications(ref);
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, ref);
        if (view != null) {
            this.defaultContextRegistered.set(false);
            view.removeWhiteboardOsgiContextModel(OsgiContextModel.DEFAULT_CONTEXT_MODEL);
        }
        this.webContainerManager.releaseContainer(this.bundle, ref);
    }

    private void installWhiteboardApplications(ServiceReference<WebContainer> ref) {
        this.lock.lock();
        try {
            this.bundleApplications.values().forEach(ba -> ba.webContainerAdded(ref));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void uninstallWhiteboardApplications(ServiceReference<WebContainer> ref) {
        this.lock.lock();
        try {
            this.bundleApplications.values().forEach(ba -> ba.webContainerRemoved(ref));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addWebContext(Bundle bundle, OsgiContextModel model) {
        this.lock.lock();
        try {
            this.osgiContexts.computeIfAbsent(model.getName(), cp -> new TreeSet()).add(model);
            this.osgiContextsList.add(model);
            this.getBundleApplication(bundle).addWebContext(model);
            this.reRegisterWebElements();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebContext(Bundle bundle, OsgiContextModel model) {
        this.lock.lock();
        try {
            this.osgiContexts.get(model.getName()).remove(model);
            this.osgiContextsList.remove(model);
            this.reRegisterWebElements();
            this.getBundleApplication(bundle).removeWebContext(model);
            WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(bundle, this.currentWebContainerReference);
            if (view != null) {
                view.clearFailedDTOInformation(model);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegisterWebElements() {
        ArrayList<BundleWhiteboardApplication> apps = new ArrayList<BundleWhiteboardApplication>(this.bundleApplications.values());
        for (BundleWhiteboardApplication app : apps) {
            WhiteboardWebContainerView view = app.getWhiteboardContainer();
            for (ElementModel<?, ?> webElement : app.getWebElements()) {
                boolean isAsync = webElement.isAsynchronusRegistration();
                try {
                    webElement.setAsynchronusRegistration(false);
                    Filter filter = webElement.getContextFilter();
                    List<OsgiContextModel> newMatching = this.resolveContexts(webElement.getRegisteringBundle(), filter);
                    List oldMatching = webElement.getContextModels();
                    if (newMatching.size() == oldMatching.size() && newMatching.containsAll(oldMatching)) continue;
                    if (newMatching.size() == 0) {
                        LOG.debug("Unregistering {} because its context selection filter doesn't match any context", webElement);
                        if (view != null) {
                            webElement.unregister(view);
                        }
                        webElement.changeContextModels(newMatching);
                        webElement.setDtoFailureCode(1);
                        continue;
                    }
                    if (oldMatching.size() == 0) {
                        webElement.changeContextModels(newMatching);
                        LOG.debug("Registering {} because its context selection filter started matching existing contexts", webElement);
                        if (view == null) continue;
                        webElement.setDtoFailureCode(-1);
                        webElement.register(view);
                        continue;
                    }
                    if (view != null) {
                        LOG.debug("Unregistering {} because its context selection filter matched new set of contexts", webElement);
                        webElement.unregister(view);
                    }
                    webElement.changeContextModels(newMatching);
                    if (view == null) continue;
                    LOG.debug("Registering {} again after its context selection filter matched new set of contexts", webElement);
                    webElement.register(view);
                }
                finally {
                    webElement.setAsynchronusRegistration(isAsync);
                }
            }
        }
    }

    public <R, D extends WebElementEventData, T extends ElementModel<R, D>> void addWebElement(Bundle bundle, T webElement) {
        this.lock.lock();
        try {
            this.getBundleApplication(bundle).addWebElement(webElement);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, D extends WebElementEventData, T extends ElementModel<R, D>> void removeWebElement(Bundle bundle, T webElement) {
        this.lock.lock();
        try {
            if (!this.acceptWabContexts.get() || webElement.getRegisteringBundle().getState() < 32) {
                webElement.setAsynchronusRegistration(false);
            }
            this.getBundleApplication(bundle).removeWebElement(webElement);
            WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(bundle, this.currentWebContainerReference);
            if (view != null) {
                view.clearFailedDTOInformation(webElement);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleWhiteboardApplication getBundleApplication(Bundle bundle) {
        BundleWhiteboardApplication bundleApplication;
        if (bundle == null) {
            return null;
        }
        this.lock.lock();
        try {
            bundleApplication = this.bundleApplications.get(bundle);
            if (bundleApplication == null) {
                bundleApplication = new BundleWhiteboardApplication(bundle, this.webContainerManager);
                ServiceReference ref = this.webContainerManager.currentWebContainerReference();
                if (ref != null) {
                    bundleApplication.webContainerAdded((ServiceReference<WebContainer>)ref);
                }
                this.bundleApplications.put(bundle, bundleApplication);
            }
        }
        finally {
            this.lock.unlock();
        }
        return bundleApplication;
    }

    public void configureFailedDTOs(ElementModel<?, ?> webElement) {
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, this.currentWebContainerReference);
        if (view != null) {
            view.failedDTOInformation(webElement);
        }
    }

    public void configureFailedDTOs(OsgiContextModel webContext) {
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, this.currentWebContainerReference);
        if (view != null) {
            view.failedDTOInformation(webContext);
        }
    }
}

