/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryListener;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.DiscoveryServiceRegistry;
import org.openhab.core.config.discovery.ScanListener;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryServiceRegistry.class})
@NonNullByDefault
public final class DiscoveryServiceRegistryImpl
implements DiscoveryServiceRegistry,
DiscoveryListener {
    private final Map<DiscoveryService, Set<DiscoveryResult>> cachedResults = new HashMap<DiscoveryService, Set<DiscoveryResult>>();
    private final Set<DiscoveryService> discoveryServices = new CopyOnWriteArraySet<DiscoveryService>();
    private final Set<DiscoveryService> discoveryServicesAll = new CopyOnWriteArraySet<DiscoveryService>();
    private final Set<DiscoveryListener> listeners = new CopyOnWriteArraySet<DiscoveryListener>();
    private final AtomicBoolean active = new AtomicBoolean();
    private final Logger logger = LoggerFactory.getLogger(DiscoveryServiceRegistryImpl.class);

    @Activate
    protected void activate() {
        this.active.set(true);
        for (DiscoveryService discoveryService : this.discoveryServicesAll) {
            this.addDiscoveryServiceActivated(discoveryService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        this.active.set(false);
        for (DiscoveryService discoveryService : this.discoveryServicesAll) {
            this.removeDiscoveryServiceActivated(discoveryService);
        }
        this.listeners.clear();
        Map<DiscoveryService, Set<DiscoveryResult>> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.clear();
        }
    }

    @Override
    public boolean abortScan(ThingTypeUID thingTypeUID) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            this.logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.abortScans(discoveryServicesForThingType);
    }

    @Override
    public boolean abortScan(String bindingId) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            this.logger.warn("No discovery service for binding '{}' found!", (Object)bindingId);
            return false;
        }
        return this.abortScans(discoveryServicesForBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        Map<DiscoveryService, Set<DiscoveryResult>> existingResults;
        this.listeners.add(listener);
        Map<DiscoveryService, Set<DiscoveryResult>> map = this.cachedResults;
        synchronized (map) {
            existingResults = Map.copyOf(this.cachedResults);
        }
        existingResults.forEach((service, results) -> results.forEach(result -> listener.thingDiscovered((DiscoveryService)service, (DiscoveryResult)result)));
    }

    @Override
    public boolean startScan(ThingTypeUID thingTypeUID, @Nullable String input, @Nullable ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            this.logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.startScans(discoveryServicesForThingType, input, listener);
    }

    @Override
    public boolean startScan(String bindingId, @Nullable String input, @Nullable ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            this.logger.warn("No discovery service for binding id '{}' found!", (Object)bindingId);
            return false;
        }
        return this.startScans(discoveryServicesForBinding, input, listener);
    }

    @Override
    public boolean supportsDiscovery(ThingTypeUID thingTypeUID) {
        return !this.getDiscoveryServices(thingTypeUID).isEmpty();
    }

    @Override
    public boolean supportsDiscovery(String bindingId) {
        return !this.getDiscoveryServices(bindingId).isEmpty();
    }

    @Override
    public List<ThingTypeUID> getSupportedThingTypes() {
        ArrayList<ThingTypeUID> thingTypeUIDs = new ArrayList<ThingTypeUID>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            thingTypeUIDs.addAll(discoveryService.getSupportedThingTypes());
        }
        return thingTypeUIDs;
    }

    @Override
    public List<String> getSupportedBindings() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : supportedThingTypes) {
                bindings.add(thingTypeUID.getBindingId());
            }
        }
        return bindings;
    }

    @Override
    public void removeDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        Map<DiscoveryService, Set<DiscoveryResult>> map = this.cachedResults;
        synchronized (map) {
            Objects.requireNonNull(this.cachedResults.computeIfAbsent(source, unused -> new HashSet())).add(result);
        }
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.thingDiscovered(source, result);
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '{}' on Thing discovered event!", (Object)listener.getClass().getName(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        Map<DiscoveryService, Set<DiscoveryResult>> map = this.cachedResults;
        synchronized (map) {
            Iterator it = this.cachedResults.getOrDefault(source, Set.of()).iterator();
            while (it.hasNext()) {
                if (!((DiscoveryResult)it.next()).getThingUID().equals((Object)thingUID)) continue;
                it.remove();
            }
        }
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.thingRemoved(source, thingUID);
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '{}' on Thing removed event!", (Object)listener.getClass().getName(), (Object)ex);
            }
        }
    }

    @Override
    public @Nullable Collection<ThingUID> removeOlderResults(DiscoveryService source, Instant timestamp, @Nullable Collection<ThingTypeUID> thingTypeUIDs, @Nullable ThingUID bridgeUID) {
        HashSet<ThingUID> removedResults = new HashSet<ThingUID>();
        for (DiscoveryListener listener : this.listeners) {
            try {
                Collection<ThingUID> olderResults = listener.removeOlderResults(source, timestamp, thingTypeUIDs, bridgeUID);
                if (olderResults == null) continue;
                removedResults.addAll(olderResults);
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '{}' on all things removed event!", (Object)listener.getClass().getName(), (Object)ex);
            }
        }
        return removedResults;
    }

    private boolean abortScans(Set<DiscoveryService> discoveryServices) {
        boolean allServicesAborted = true;
        for (DiscoveryService discoveryService : discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            try {
                this.logger.debug("Abort scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getName());
                discoveryService.abortScan();
                this.logger.debug("Scan for thing types '{}' aborted on '{}'.", supportedThingTypes, (Object)discoveryService.getClass().getName());
            }
            catch (Exception ex) {
                this.logger.error("Cannot abort scan for thing types '{}' on '{}'!", new Object[]{supportedThingTypes, discoveryService.getClass().getName(), ex});
                allServicesAborted = false;
            }
        }
        return allServicesAborted;
    }

    private boolean startScans(Set<DiscoveryService> discoveryServices, @Nullable String input, @Nullable ScanListener listener) {
        boolean atLeastOneDiscoveryServiceHasBeenStarted = false;
        if (discoveryServices.size() > 1) {
            this.logger.debug("Trying to start {} scans with an aggregating listener.", (Object)discoveryServices.size());
            AggregatingScanListener aggregatingScanListener = new AggregatingScanListener(discoveryServices.size(), listener);
            for (DiscoveryService discoveryService : discoveryServices) {
                if (this.startScan(discoveryService, input, (ScanListener)aggregatingScanListener)) {
                    atLeastOneDiscoveryServiceHasBeenStarted = true;
                    continue;
                }
                this.logger.debug("Reducing number of discovery services in aggregating listener, because discovery service failed to start scan.");
                aggregatingScanListener.reduceNumberOfDiscoveryServices();
            }
        } else if (this.startScan(discoveryServices.iterator().next(), input, listener)) {
            atLeastOneDiscoveryServiceHasBeenStarted = true;
        }
        return atLeastOneDiscoveryServiceHasBeenStarted;
    }

    private boolean startScan(DiscoveryService discoveryService, @Nullable String input, @Nullable ScanListener listener) {
        Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
        try {
            this.logger.debug("Triggering scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getSimpleName());
            if (discoveryService.isScanInputSupported() && input != null) {
                discoveryService.startScan(input, listener);
            } else {
                discoveryService.startScan(listener);
            }
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Cannot trigger scan for thing types '{}' on '{}'!", new Object[]{supportedThingTypes, discoveryService.getClass().getSimpleName(), ex});
            return false;
        }
    }

    private Set<DiscoveryService> getDiscoveryServices(ThingTypeUID thingTypeUID) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
            if (!discoveryThingTypes.contains(thingTypeUID)) continue;
            discoveryServices.add(discoveryService);
        }
        return discoveryServices;
    }

    @Override
    public Set<DiscoveryService> getDiscoveryServices(String bindingId) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : discoveryThingTypes) {
                if (!thingTypeUID.getBindingId().equals(bindingId)) continue;
                discoveryServices.add(discoveryService);
            }
        }
        return discoveryServices;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryServicesAll.add(discoveryService);
        if (this.active.get()) {
            this.addDiscoveryServiceActivated(discoveryService);
        }
    }

    private void addDiscoveryServiceActivated(DiscoveryService discoveryService) {
        discoveryService.addDiscoveryListener(this);
        this.discoveryServices.add(discoveryService);
    }

    protected void removeDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryServicesAll.remove(discoveryService);
        if (this.active.get()) {
            this.removeDiscoveryServiceActivated(discoveryService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDiscoveryServiceActivated(DiscoveryService discoveryService) {
        this.discoveryServices.remove(discoveryService);
        discoveryService.removeDiscoveryListener(this);
        Map<DiscoveryService, Set<DiscoveryResult>> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.remove(discoveryService);
        }
    }

    private int getMaxScanTimeout(Set<DiscoveryService> discoveryServices) {
        int result = 0;
        for (DiscoveryService discoveryService : discoveryServices) {
            if (discoveryService.getScanTimeout() <= result) continue;
            result = discoveryService.getScanTimeout();
        }
        return result;
    }

    @Override
    public int getMaxScanTimeout(ThingTypeUID thingTypeUID) {
        return this.getMaxScanTimeout(this.getDiscoveryServices(thingTypeUID));
    }

    @Override
    public int getMaxScanTimeout(String bindingId) {
        return this.getMaxScanTimeout(this.getDiscoveryServices(bindingId));
    }

    private final class AggregatingScanListener
    implements ScanListener {
        private final @Nullable ScanListener listener;
        private int finishedDiscoveryServices = 0;
        private boolean errorOccurred = false;
        private int numberOfDiscoveryServices;

        private AggregatingScanListener(@Nullable int numberOfDiscoveryServices, ScanListener listener) {
            this.numberOfDiscoveryServices = numberOfDiscoveryServices;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinished() {
            ScanListener listener = null;
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                ++this.finishedDiscoveryServices;
                DiscoveryServiceRegistryImpl.this.logger.debug("Finished {} of {} discovery services.", (Object)this.finishedDiscoveryServices, (Object)this.numberOfDiscoveryServices);
                if (!this.errorOccurred && this.finishedDiscoveryServices == this.numberOfDiscoveryServices) {
                    listener = this.listener;
                }
            }
            if (listener != null) {
                listener.onFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onErrorOccurred(@Nullable Exception exception) {
            ScanListener listener = null;
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                if (!this.errorOccurred) {
                    listener = this.listener;
                    this.errorOccurred = true;
                } else if (!(exception instanceof CancellationException) && exception != null) {
                    DiscoveryServiceRegistryImpl.this.logger.warn("Error occurred while executing discovery service: {}", (Object)exception.getMessage(), (Object)exception);
                }
            }
            if (listener != null) {
                listener.onErrorOccurred(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reduceNumberOfDiscoveryServices() {
            ScanListener listener = null;
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                --this.numberOfDiscoveryServices;
                if (!this.errorOccurred && this.finishedDiscoveryServices == this.numberOfDiscoveryServices) {
                    listener = this.listener;
                }
            }
            if (listener != null) {
                listener.onFinished();
            }
        }
    }
}

