/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.discovery.DiscoveryListener;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultBuilder;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.ScanListener;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractDiscoveryService
implements DiscoveryService {
    private static final String DISCOVERY_THREADPOOL_NAME = "discovery";
    private final Logger logger = LoggerFactory.getLogger(AbstractDiscoveryService.class);
    protected final ScheduledExecutorService scheduler;
    private final Set<DiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<DiscoveryListener>();
    protected @Nullable ScanListener scanListener;
    private volatile boolean backgroundDiscoveryEnabled;
    private final @Nullable String scanInputLabel;
    private final @Nullable String scanInputDescription;
    private final Map<ThingUID, DiscoveryResult> cachedResults = new HashMap<ThingUID, DiscoveryResult>();
    private final Set<ThingTypeUID> supportedThingTypes;
    private final int timeout;
    private Instant timestampOfLastScan = Instant.MIN;
    private @Nullable ScheduledFuture<?> scheduledStop;
    @NonNullByDefault(value={})
    protected TranslationProvider i18nProvider;
    @NonNullByDefault(value={})
    protected LocaleProvider localeProvider;

    protected AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault, @Nullable String scanInputLabel, @Nullable String scanInputDescription) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout must be >= 0!");
        }
        this.scheduler = ThreadPoolManager.getScheduledPool((String)DISCOVERY_THREADPOOL_NAME);
        this.supportedThingTypes = supportedThingTypes == null ? Set.of() : Set.copyOf(supportedThingTypes);
        this.timeout = timeout;
        this.backgroundDiscoveryEnabled = backgroundDiscoveryEnabledByDefault;
        this.scanInputLabel = scanInputLabel;
        this.scanInputDescription = scanInputDescription;
    }

    protected AbstractDiscoveryService(ScheduledExecutorService scheduler, @Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault, @Nullable String scanInputLabel, @Nullable String scanInputDescription) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout must be >= 0!");
        }
        this.scheduler = scheduler;
        this.supportedThingTypes = supportedThingTypes == null ? Set.of() : Set.copyOf(supportedThingTypes);
        this.timeout = timeout;
        this.backgroundDiscoveryEnabled = backgroundDiscoveryEnabledByDefault;
        this.scanInputLabel = scanInputLabel;
        this.scanInputDescription = scanInputDescription;
    }

    protected AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault) throws IllegalArgumentException {
        this(supportedThingTypes, timeout, backgroundDiscoveryEnabledByDefault, null, null);
    }

    protected AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout) throws IllegalArgumentException {
        this(supportedThingTypes, timeout, true);
    }

    protected AbstractDiscoveryService(int timeout) throws IllegalArgumentException {
        this(null, timeout);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.supportedThingTypes;
    }

    @Override
    public boolean isScanInputSupported() {
        return this.getScanInputLabel() != null && this.getScanInputDescription() != null;
    }

    @Override
    public @Nullable String getScanInputLabel() {
        return this.scanInputLabel;
    }

    @Override
    public @Nullable String getScanInputDescription() {
        return this.scanInputDescription;
    }

    @Override
    public int getScanTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isBackgroundDiscoveryEnabled() {
        return this.backgroundDiscoveryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(@Nullable DiscoveryListener listener) {
        Map<ThingUID, DiscoveryResult> existingResults;
        if (listener == null) {
            return;
        }
        this.discoveryListeners.add(listener);
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            existingResults = Map.copyOf(this.cachedResults);
        }
        for (DiscoveryResult existingResult : existingResults.values()) {
            listener.thingDiscovered(this, existingResult);
        }
    }

    @Override
    public void removeDiscoveryListener(@Nullable DiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    @Override
    public void startScan(@Nullable ScanListener listener) {
        this.startScanInternal(null, listener);
    }

    @Override
    public void startScan(String input, @Nullable ScanListener listener) {
        this.startScanInternal(input, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScanInternal(@Nullable String input, @Nullable ScanListener listener) {
        this.stopScan();
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            ScheduledFuture<?> scheduledStop = this.scheduledStop;
            if (scheduledStop != null) {
                scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            this.scanListener = listener;
            if (this.getScanTimeout() > 0) {
                scheduledStop = this.scheduler.schedule(() -> {
                    try {
                        this.stopScan();
                    }
                    catch (Exception e) {
                        this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                    }
                }, (long)this.getScanTimeout(), TimeUnit.SECONDS);
            }
            this.timestampOfLastScan = Instant.now();
        }
        try {
            if (this.isScanInputSupported() && input != null) {
                this.startScan(input);
            } else {
                this.startScan();
            }
        }
        catch (Exception ex) {
            AbstractDiscoveryService abstractDiscoveryService2 = this;
            synchronized (abstractDiscoveryService2) {
                ScheduledFuture<?> scheduledStop = this.scheduledStop;
                if (scheduledStop != null) {
                    scheduledStop.cancel(false);
                    this.scheduledStop = null;
                }
                this.scanListener = null;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortScan() {
        ScanListener scanListener = null;
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            ScheduledFuture<?> scheduledStop = this.scheduledStop;
            if (scheduledStop != null) {
                scheduledStop.cancel(true);
                this.scheduledStop = null;
            }
            scanListener = this.scanListener;
            this.scanListener = null;
        }
        if (scanListener != null) {
            CancellationException e = new CancellationException("Scan has been aborted.");
            scanListener.onErrorOccurred(e);
        }
    }

    protected abstract void startScan();

    protected void startScan(String input) {
        this.logger.warn("Discovery with input parameter not implemented by service '{}'!", (Object)this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopScan() {
        ScanListener scanListener = null;
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            scanListener = this.scanListener;
            this.scanListener = null;
        }
        if (scanListener != null) {
            scanListener.onFinished();
        }
    }

    protected void thingDiscovered(DiscoveryResult discoveryResult) {
        this.thingDiscovered(discoveryResult, FrameworkUtil.getBundle(this.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingDiscovered(DiscoveryResult discoveryResult, @Nullable Bundle bundle) {
        DiscoveryResult discoveryResultNew = this.getLocalizedDiscoveryResult(discoveryResult, bundle);
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            this.scheduler.execute(() -> {
                try {
                    discoveryListener.thingDiscovered(this, discoveryResultNew);
                }
                catch (Exception e) {
                    this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
                }
            });
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.put(discoveryResultNew.getThingUID(), discoveryResultNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingRemoved(ThingUID thingUID) {
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingRemoved(this, thingUID);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.remove(thingUID);
        }
    }

    protected void removeOlderResults(Instant timestamp) {
        this.removeOlderResults(timestamp, null, null);
    }

    protected void removeOlderResults(Instant timestamp, @Nullable ThingUID bridgeUID) {
        this.removeOlderResults(timestamp, null, bridgeUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOlderResults(Instant timestamp, @Nullable Collection<ThingTypeUID> thingTypeUIDs, @Nullable ThingUID bridgeUID) {
        HashSet<ThingUID> removedThings = new HashSet<ThingUID>();
        Collection toBeRemoved = thingTypeUIDs != null ? thingTypeUIDs : this.getSupportedThingTypes();
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                Collection<ThingUID> removed = discoveryListener.removeOlderResults(this, timestamp, toBeRemoved, bridgeUID);
                if (removed == null) continue;
                removedThings.addAll(removed);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        if (!removedThings.isEmpty()) {
            Map<ThingUID, DiscoveryResult> map = this.cachedResults;
            synchronized (map) {
                for (ThingUID uid : removedThings) {
                    this.cachedResults.remove(uid);
                }
            }
        }
    }

    protected void activate(@Nullable Map<String, Object> configProperties) {
        if (configProperties != null) {
            this.backgroundDiscoveryEnabled = (Boolean)ConfigParser.valueAsOrElse((Object)configProperties.get("background"), Boolean.class, (Object)this.backgroundDiscoveryEnabled);
        }
        if (this.backgroundDiscoveryEnabled) {
            this.startBackgroundDiscovery();
            this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
        }
    }

    protected void modified(@Nullable Map<String, Object> configProperties) {
        if (configProperties != null) {
            boolean enabled = (Boolean)ConfigParser.valueAsOrElse((Object)configProperties.get("background"), Boolean.class, (Object)this.backgroundDiscoveryEnabled);
            if (this.backgroundDiscoveryEnabled && !enabled) {
                this.stopBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' disabled.", (Object)this.getClass().getName());
            } else if (!this.backgroundDiscoveryEnabled && enabled) {
                this.startBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
            }
            this.backgroundDiscoveryEnabled = enabled;
        }
    }

    protected void deactivate() {
        if (this.backgroundDiscoveryEnabled) {
            this.stopBackgroundDiscovery();
        }
    }

    protected void startBackgroundDiscovery() {
    }

    protected void stopBackgroundDiscovery() {
    }

    protected synchronized Instant getTimestampOfLastScan() {
        return this.timestampOfLastScan;
    }

    private String inferKey(DiscoveryResult discoveryResult, String lastSegment) {
        return "discovery." + discoveryResult.getThingUID().getAsString().replace(":", ".") + "." + lastSegment;
    }

    protected DiscoveryResult getLocalizedDiscoveryResult(DiscoveryResult discoveryResult, @Nullable Bundle bundle) {
        TranslationProvider i18nProvider = this.i18nProvider;
        LocaleProvider localeProvider = this.localeProvider;
        if (i18nProvider != null && localeProvider != null) {
            String currentLabel = discoveryResult.getLabel();
            String key = I18nUtil.stripConstantOr((String)currentLabel, () -> this.inferKey(discoveryResult, "label"));
            ParsedKey parsedKey = new ParsedKey(key);
            String label = i18nProvider.getText(bundle, parsedKey.key, currentLabel, localeProvider.getLocale(), parsedKey.args);
            if (currentLabel.equals(label)) {
                return discoveryResult;
            }
            return DiscoveryResultBuilder.create(discoveryResult).withLabel(label).build();
        }
        return discoveryResult;
    }

    private static final class ParsedKey {
        private static final int LIMIT = 2;
        private final String key;
        private final Object @Nullable [] args;

        private ParsedKey(String label) {
            String[] parts = label.split("\\s+", 2);
            this.key = parts[0];
            this.args = parts.length == 1 ? null : Arrays.stream(parts[1].replaceAll("\\[|\\]|\"", "").split(",")).filter(s -> !s.isBlank()).map(String::trim).toArray(Object[]::new);
        }
    }
}

