/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonInfoProvider;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.AddonFinderConstants;
import org.openhab.core.config.discovery.addon.AddonFinderService;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.i18n.LocaleProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={AddonSuggestionService.class}, name="addon-suggestion-service", configurationPid={"org.openhab.addons"})
public class AddonSuggestionService {
    public static final String SERVICE_NAME = "addon-suggestion-service";
    private final Logger logger = LoggerFactory.getLogger(AddonSuggestionService.class);
    private final Set<AddonInfoProvider> addonInfoProviders = ConcurrentHashMap.newKeySet();
    private final List<AddonFinder> addonFinders = new ArrayList<AddonFinder>();
    private final LocaleProvider localeProvider;
    private volatile @Nullable AddonFinderService addonFinderService;
    private final Map<String, Boolean> baseFinderConfig = new ConcurrentHashMap<String, Boolean>();

    @Activate
    public AddonSuggestionService(@Reference LocaleProvider localeProvider, Map<String, Object> config) {
        this.localeProvider = localeProvider;
        AddonFinderConstants.SUGGESTION_FINDERS.forEach(f -> {
            Boolean bl = this.baseFinderConfig.put((String)f, false);
        });
        this.modified(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.clear();
        }
        this.addonInfoProviders.clear();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addAddonFinderService(AddonFinderService addonFinderService) {
        this.addonFinderService = addonFinderService;
        this.initAddonFinderService();
    }

    protected void removeAddonFinderService(AddonFinderService addonFinderService) {
        AddonFinderService finderService = this.addonFinderService;
        if (finderService != null && addonFinderService.getClass().isAssignableFrom(finderService.getClass())) {
            this.addonFinderService = null;
        }
    }

    @Modified
    public void modified(@Nullable Map<String, Object> config) {
        if (config != null) {
            AddonFinderService finderService = this.addonFinderService;
            this.baseFinderConfig.forEach((finder, currentEnabled) -> {
                String cfgParam = AddonFinderConstants.SUGGESTION_FINDER_CONFIGS.get(finder);
                if (cfgParam != null) {
                    boolean newEnabled = (Boolean)ConfigParser.valueAsOrElse(config.get(cfgParam), Boolean.class, (Object)true);
                    if (currentEnabled != newEnabled) {
                        String type = AddonFinderConstants.SUGGESTION_FINDER_TYPES.get(finder);
                        if (type != null) {
                            this.logger.debug("baseFinderConfig {} {} = {} => updating from {} to {}", new Object[]{finder, cfgParam, config.get(cfgParam), currentEnabled, newEnabled});
                            this.baseFinderConfig.put((String)finder, newEnabled);
                            if (finderService != null) {
                                if (newEnabled) {
                                    finderService.install(type);
                                } else {
                                    finderService.uninstall(type);
                                }
                            }
                        } else {
                            this.logger.warn("Failed to resolve addon suggestion finder type for suggestion finder {}", finder);
                        }
                    }
                }
            });
        }
    }

    private void initAddonFinderService() {
        AddonFinderService finderService = this.addonFinderService;
        if (finderService == null) {
            return;
        }
        for (Map.Entry<String, Boolean> entry : this.baseFinderConfig.entrySet()) {
            String type = AddonFinderConstants.SUGGESTION_FINDER_TYPES.get(entry.getKey());
            if (type != null) {
                Boolean bl = entry.getValue();
                if (!(bl instanceof Boolean)) continue;
                Boolean enabled = bl;
                if (enabled.booleanValue()) {
                    finderService.install(type);
                    continue;
                }
                finderService.uninstall(type);
                continue;
            }
            this.logger.warn("Failed to resolve addon suggestion finder type for suggestion finder {}", (Object)entry.getKey());
        }
    }

    private boolean isFinderEnabled(AddonFinder finder) {
        if (finder instanceof BaseAddonFinder) {
            BaseAddonFinder baseFinder = (BaseAddonFinder)finder;
            return this.baseFinderConfig.getOrDefault(baseFinder.getServiceName(), true);
        }
        return true;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addAddonInfoProvider(AddonInfoProvider addonInfoProvider) {
        this.addonInfoProviders.add(addonInfoProvider);
        this.changed();
    }

    public void removeAddonInfoProvider(AddonInfoProvider addonInfoProvider) {
        if (this.addonInfoProviders.remove(addonInfoProvider)) {
            this.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addAddonFinder(AddonFinder addonFinder) {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.add(addonFinder);
        }
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddonFinder(AddonFinder addonFinder) {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.remove(addonFinder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changed() {
        Locale locale = this.localeProvider.getLocale();
        List candidates = this.addonInfoProviders.stream().map(p -> p.getAddonInfos(locale)).flatMap(Collection::stream).toList();
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.stream().filter(this::isFinderEnabled).forEach(f -> f.setAddonCandidates(candidates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AddonInfo> getSuggestedAddons(@Nullable Locale locale) {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            return this.addonFinders.stream().filter(this::isFinderEnabled).map(f -> f.getSuggestedAddons()).flatMap(Collection::stream).collect(Collectors.toSet());
        }
    }
}

