/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm.negotiation;

import java.util.Set;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.policy.Policy;

public interface HashAlgorithmNegotiator {
    public HashAlgorithm negotiateHashAlgorithm(Set<HashAlgorithm> var1);

    public static HashAlgorithmNegotiator negotiateSignatureHashAlgorithm(Policy policy) {
        return HashAlgorithmNegotiator.negotiateByPolicy(policy.getSignatureHashAlgorithmPolicy());
    }

    public static HashAlgorithmNegotiator negotiateRevocationSignatureAlgorithm(Policy policy) {
        return HashAlgorithmNegotiator.negotiateByPolicy(policy.getRevocationSignatureHashAlgorithmPolicy());
    }

    public static HashAlgorithmNegotiator negotiateByPolicy(final Policy.HashAlgorithmPolicy hashAlgorithmPolicy) {
        return new HashAlgorithmNegotiator(){

            @Override
            public HashAlgorithm negotiateHashAlgorithm(Set<HashAlgorithm> orderedPreferencesSet) {
                for (HashAlgorithm preference : orderedPreferencesSet) {
                    if (!hashAlgorithmPolicy.isAcceptable(preference)) continue;
                    return preference;
                }
                return hashAlgorithmPolicy.defaultHashAlgorithm();
            }
        };
    }
}

