/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum HashAlgorithm {
    MD5(1, "MD5"),
    SHA1(2, "SHA1"),
    RIPEMD160(3, "RIPEMD160"),
    SHA256(8, "SHA256"),
    SHA384(9, "SHA384"),
    SHA512(10, "SHA512"),
    SHA224(11, "SHA224"),
    SHA3_256(12, "SHA3-256"),
    SHA3_512(14, "SHA3-512");

    private static final Map<Integer, HashAlgorithm> ID_MAP;
    private static final Map<String, HashAlgorithm> NAME_MAP;
    private final int algorithmId;
    private final String name;

    @Nullable
    public static HashAlgorithm fromId(int id) {
        return ID_MAP.get(id);
    }

    @Nonnull
    public static HashAlgorithm requireFromId(int id) {
        HashAlgorithm algorithm = HashAlgorithm.fromId(id);
        if (algorithm == null) {
            throw new NoSuchElementException("No HashAlgorithm found for id " + id);
        }
        return algorithm;
    }

    @Nullable
    public static HashAlgorithm fromName(String name) {
        String algorithmName = name.toUpperCase();
        HashAlgorithm algorithm = NAME_MAP.get(algorithmName);
        if (algorithm == null) {
            algorithm = NAME_MAP.get(algorithmName.replace("-", ""));
        }
        return algorithm;
    }

    private HashAlgorithm(int id, String name) {
        this.algorithmId = id;
        this.name = name;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public String getAlgorithmName() {
        return this.name;
    }

    static {
        ID_MAP = new HashMap<Integer, HashAlgorithm>();
        NAME_MAP = new HashMap<String, HashAlgorithm>();
        for (HashAlgorithm h : HashAlgorithm.values()) {
            ID_MAP.put(h.algorithmId, h);
            NAME_MAP.put(h.name, h);
        }
    }
}

