/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.hla;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.minidns.AbstractDnsClient;
import org.minidns.MiniDnsException;
import org.minidns.dnsname.DnsName;
import org.minidns.hla.ResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.hla.srv.SrvServiceProto;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.InternetAddressRR;
import org.minidns.record.SRV;
import org.minidns.util.SrvUtil;

public class SrvResolverResult
extends ResolverResult<SRV> {
    private final ResolverApi resolver;
    private final AbstractDnsClient.IpVersionSetting ipVersion;
    private final SrvServiceProto srvServiceProto;
    private List<ResolvedSrvRecord> sortedSrvResolvedAddresses;

    SrvResolverResult(ResolverResult<SRV> srvResult, SrvServiceProto srvServiceProto, ResolverApi resolver) throws MiniDnsException.NullResultException {
        super(srvResult.question, srvResult.result, srvResult.unverifiedReasons);
        this.resolver = resolver;
        this.ipVersion = resolver.getClient().getPreferedIpVersion();
        this.srvServiceProto = srvServiceProto;
    }

    public List<ResolvedSrvRecord> getSortedSrvResolvedAddresses() throws IOException {
        if (this.sortedSrvResolvedAddresses != null) {
            return this.sortedSrvResolvedAddresses;
        }
        this.throwIseIfErrorResponse();
        if (this.isServiceDecidedlyNotAvailableAtThisDomain()) {
            return null;
        }
        List<SRV> srvRecords = SrvUtil.sortSrvRecords(this.getAnswers());
        ArrayList<ResolvedSrvRecord> res = new ArrayList<ResolvedSrvRecord>(srvRecords.size());
        for (SRV srvRecord : srvRecords) {
            ResolverResult<A> aRecordsResult = null;
            ResolverResult<AAAA> aaaaRecordsResult = null;
            Set<Object> aRecords = Collections.emptySet();
            if (this.ipVersion.v4 && (aRecordsResult = this.resolver.resolve(srvRecord.target, A.class)).wasSuccessful() && !aRecordsResult.hasUnverifiedReasons()) {
                aRecords = aRecordsResult.getAnswers();
            }
            Set<Object> aaaaRecords = Collections.emptySet();
            if (this.ipVersion.v6 && (aaaaRecordsResult = this.resolver.resolve(srvRecord.target, AAAA.class)).wasSuccessful() && !aaaaRecordsResult.hasUnverifiedReasons()) {
                aaaaRecords = aaaaRecordsResult.getAnswers();
            }
            if (aRecords.isEmpty() && aaaaRecords.isEmpty()) continue;
            ArrayList<InternetAddressRR<? extends InetAddress>> srvAddresses = new ArrayList<InternetAddressRR<? extends InetAddress>>(aRecords.size() + aaaaRecords.size());
            switch (this.ipVersion) {
                case v4only: {
                    srvAddresses.addAll(aRecords);
                    break;
                }
                case v6only: {
                    srvAddresses.addAll(aaaaRecords);
                    break;
                }
                case v4v6: {
                    srvAddresses.addAll(aRecords);
                    srvAddresses.addAll(aaaaRecords);
                    break;
                }
                case v6v4: {
                    srvAddresses.addAll(aaaaRecords);
                    srvAddresses.addAll(aRecords);
                }
            }
            ResolvedSrvRecord resolvedSrvAddresses = new ResolvedSrvRecord(this.question.name, this.srvServiceProto, srvRecord, srvAddresses, aRecordsResult, aaaaRecordsResult);
            res.add(resolvedSrvAddresses);
        }
        this.sortedSrvResolvedAddresses = res;
        return res;
    }

    public boolean isServiceDecidedlyNotAvailableAtThisDomain() {
        Set answers = this.getAnswers();
        if (answers.size() != 1) {
            return false;
        }
        SRV singleAnswer = (SRV)answers.iterator().next();
        return !singleAnswer.isServiceAvailable();
    }

    @SafeVarargs
    public static List<ResolvedSrvRecord> sortMultiple(Collection<ResolvedSrvRecord> ... resolvedSrvRecordCollections) {
        int srvRecordsCount = 0;
        for (Collection<ResolvedSrvRecord> resolvedSrvRecords : resolvedSrvRecordCollections) {
            if (resolvedSrvRecords == null) continue;
            srvRecordsCount += resolvedSrvRecords.size();
        }
        ArrayList<SRV> srvToSort = new ArrayList<SRV>(srvRecordsCount);
        IdentityHashMap<SRV, ResolvedSrvRecord> identityMap = new IdentityHashMap<SRV, ResolvedSrvRecord>(srvRecordsCount);
        for (Collection<ResolvedSrvRecord> resolvedSrvRecords : resolvedSrvRecordCollections) {
            if (resolvedSrvRecords == null) continue;
            for (ResolvedSrvRecord resolvedSrvRecord : resolvedSrvRecords) {
                srvToSort.add(resolvedSrvRecord.srv);
                identityMap.put(resolvedSrvRecord.srv, resolvedSrvRecord);
            }
        }
        List<SRV> sortedSrvs = SrvUtil.sortSrvRecords(srvToSort);
        assert (sortedSrvs.size() == srvRecordsCount);
        ArrayList<ResolvedSrvRecord> res = new ArrayList<ResolvedSrvRecord>(srvRecordsCount);
        for (SRV sortedSrv : sortedSrvs) {
            ResolvedSrvRecord resolvedSrvRecord = (ResolvedSrvRecord)identityMap.get(sortedSrv);
            res.add(resolvedSrvRecord);
        }
        return res;
    }

    public static final class ResolvedSrvRecord {
        public final DnsName name;
        public final SrvServiceProto srvServiceProto;
        public final SRV srv;
        public final List<InternetAddressRR<? extends InetAddress>> addresses;
        public final ResolverResult<A> aRecordsResult;
        public final ResolverResult<AAAA> aaaaRecordsResult;
        public final int port;

        private ResolvedSrvRecord(DnsName name, SrvServiceProto srvServiceProto, SRV srv, List<InternetAddressRR<? extends InetAddress>> addresses, ResolverResult<A> aRecordsResult, ResolverResult<AAAA> aaaaRecordsResult) {
            this.name = name;
            this.srvServiceProto = srvServiceProto;
            this.srv = srv;
            this.addresses = Collections.unmodifiableList(addresses);
            this.port = srv.port;
            this.aRecordsResult = aRecordsResult;
            this.aaaaRecordsResult = aaaaRecordsResult;
        }
    }
}

