/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.offline.OfflineMessageHeader;
import org.jivesoftware.smackx.offline.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.offline.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class OfflineMessageManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(OfflineMessageManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private static final Map<XMPPConnection, OfflineMessageManager> INSTANCES = new WeakHashMap<XMPPConnection, OfflineMessageManager>();
    private static final StanzaFilter PACKET_FILTER = new AndFilter(new StanzaExtensionFilter(new OfflineMessageInfo()), StanzaTypeFilter.MESSAGE);
    private ServiceDiscoveryManager serviceDiscoveryManager;

    private OfflineMessageManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
    }

    public static synchronized OfflineMessageManager getInstanceFor(XMPPConnection connection) {
        OfflineMessageManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new OfflineMessageManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public boolean supportsFlexibleRetrieval() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serviceDiscoveryManager.serverSupportsFeature(NAMESPACE);
    }

    public int getMessageCount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info = this.serviceDiscoveryManager.discoverInfo(null, NAMESPACE);
        DataForm dataForm = DataForm.from(info, NAMESPACE);
        if (dataForm == null) {
            return 0;
        }
        String numberOfMessagesString = dataForm.getField("number_of_messages").getFirstValue();
        return Integer.parseInt(numberOfMessagesString);
    }

    public List<OfflineMessageHeader> getHeaders() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<OfflineMessageHeader> answer = new ArrayList<OfflineMessageHeader>();
        DiscoverItems items = this.serviceDiscoveryManager.discoverItems(null, NAMESPACE);
        for (DiscoverItems.Item item : items.getItems()) {
            answer.add(new OfflineMessageHeader(item));
        }
        return answer;
    }

    public List<Message> getMessages(final List<String> nodes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<Message> messages = new ArrayList<Message>(nodes.size());
        OfflineMessageRequest request = new OfflineMessageRequest();
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("view");
            request.addItem(item);
        }
        AndFilter messageFilter = new AndFilter(PACKET_FILTER, new StanzaFilter(){

            @Override
            public boolean accept(Stanza packet) {
                OfflineMessageInfo info = packet.getExtension(OfflineMessageInfo.class);
                return nodes.contains(info.getNode());
            }
        });
        int pendingNodes = nodes.size();
        try (StanzaCollector messageCollector = this.connection().createStanzaCollector(messageFilter);){
            Message message;
            this.connection().sendIqRequestAndWaitForResponse(request);
            do {
                if ((message = (Message)messageCollector.nextResult()) != null) {
                    messages.add(message);
                    --pendingNodes;
                    continue;
                }
                if (message != null || pendingNodes <= 0) continue;
                LOGGER.log(Level.WARNING, "Did not receive all expected offline messages. " + pendingNodes + " are missing.");
            } while (message != null && pendingNodes > 0);
        }
        return messages;
    }

    public List<Message> getMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<Message> messages;
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setFetch(true);
        StanzaCollector resultCollector = this.connection().createStanzaCollectorAndSend(request);
        StanzaCollector.Configuration messageCollectorConfiguration = StanzaCollector.newConfiguration().setStanzaFilter(PACKET_FILTER).setCollectorToReset(resultCollector);
        try (StanzaCollector messageCollector = this.connection().createStanzaCollector(messageCollectorConfiguration);){
            Message message;
            resultCollector.nextResultOrThrow();
            messageCollector.cancel();
            messages = new ArrayList<Message>(messageCollector.getCollectedCount());
            while ((message = (Message)messageCollector.pollResult()) != null) {
                messages.add(message);
            }
        }
        return messages;
    }

    public void deleteMessages(List<String> nodes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setType(IQ.Type.set);
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("remove");
            request.addItem(item);
        }
        this.connection().sendIqRequestAndWaitForResponse(request);
    }

    public void deleteMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setType(IQ.Type.set);
        request.setPurge(true);
        this.connection().sendIqRequestAndWaitForResponse(request);
    }
}

