/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.rce;

import java.net.InetAddress;
import org.jivesoftware.smack.util.ToStringUtil;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.SingleAddressRemoteConnectionEndpoint;

public final class RemoteConnectionException<RCE extends RemoteConnectionEndpoint> {
    private final RemoteConnectionEndpoint.InetSocketAddressCoupling<RCE> address;
    private final Exception exception;
    private transient String toStringCache;

    public RemoteConnectionException(RCE remoteConnectionEndpoint, InetAddress inetAddress, Exception exception) {
        this(new RemoteConnectionEndpoint.InetSocketAddressCoupling<RCE>(remoteConnectionEndpoint, inetAddress), exception);
    }

    public RemoteConnectionException(RemoteConnectionEndpoint.InetSocketAddressCoupling<RCE> address, Exception exception) {
        this.address = address;
        this.exception = exception;
    }

    public RemoteConnectionEndpoint.InetSocketAddressCoupling<RCE> getAddress() {
        return this.address;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getErrorMessage() {
        return "'" + String.valueOf(this.address) + "' failed because: " + String.valueOf(this.exception);
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = ToStringUtil.builderFor(RemoteConnectionException.class).addValue("address", this.address).addValue("exception", this.exception).build();
        }
        return this.toStringCache;
    }

    public static <SARCE extends SingleAddressRemoteConnectionEndpoint> RemoteConnectionException<SARCE> from(SARCE remoteConnectionEndpoint, Exception exception) {
        return new RemoteConnectionException<SARCE>(remoteConnectionEndpoint, remoteConnectionEndpoint.getInetAddress(), exception);
    }
}

