/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class UserIDPacket
extends ContainedPacket
implements UserDataPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.idData = bCPGInputStream.readAll();
    }

    public UserIDPacket(String string2) {
        this.idData = Strings.toUTF8ByteArray(string2);
    }

    public UserIDPacket(byte[] byArray) {
        this.idData = Arrays.clone(byArray);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone(this.idData);
    }

    public boolean equals(Object object) {
        if (object instanceof UserIDPacket) {
            return Arrays.areEqual(this.idData, ((UserIDPacket)object).idData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idData);
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(13, this.idData);
    }
}

