/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.team.internal.ui.dialogs.ResourceMappingHierarchyArea;

public class AdditionalMappingsDialog
extends DetailsDialog {
    private ResourceMappingHierarchyArea selectedMappingsArea;
    private ResourceMappingHierarchyArea allMappingsArea;
    private final ISynchronizationScope scope;
    private final ISynchronizationContext context;
    private String previewMessage;
    protected boolean forcePreview = true;

    public AdditionalMappingsDialog(Shell parentShell, String dialogTitle, ISynchronizationScope scope, ISynchronizationContext context) {
        super(parentShell, dialogTitle);
        this.scope = scope;
        this.context = context;
    }

    @Override
    protected void createMainDialogArea(Composite parent) {
        this.createWrappingLabel(parent, TeamUIMessages.AdditionalMappingsDialog_0);
        this.createSelectedMappingsArea(parent);
        this.createAllMappingsArea(parent);
        this.createPreviewOptionArea(parent);
    }

    private void createSelectedMappingsArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.selectedMappingsArea = ResourceMappingHierarchyArea.create(this.scope.asInputScope(), null);
        this.selectedMappingsArea.setDescription(TeamUIMessages.AdditionalMappingsDialog_1);
        this.selectedMappingsArea.createArea(composite);
        Label seperator = new Label(composite, 258);
        seperator.setLayoutData((Object)new GridData(768));
    }

    private void createAllMappingsArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.allMappingsArea = ResourceMappingHierarchyArea.create(this.scope, this.context);
        this.allMappingsArea.setDescription(TeamUIMessages.AdditionalMappingsDialog_2);
        this.allMappingsArea.createArea(composite);
    }

    private void createPreviewOptionArea(Composite parent) {
        if (this.previewMessage != null) {
            final Button forcePreviewButton = SWTUtils.createCheckBox(parent, this.previewMessage);
            forcePreviewButton.setSelection(this.forcePreview);
            forcePreviewButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AdditionalMappingsDialog.this.forcePreview = forcePreviewButton.getSelection();
                }
            });
        }
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        return null;
    }

    @Override
    protected void updateEnablements() {
    }

    @Override
    protected boolean includeDetailsButton() {
        return false;
    }

    public String getPreviewMessage() {
        return this.previewMessage;
    }

    public void setPreviewMessage(String previewMessage) {
        this.previewMessage = previewMessage;
    }

    public boolean isForcePreview() {
        return this.forcePreview;
    }
}

