// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A bucket-level setting for Amazon S3 general purpose buckets used to prevent the upload of new objects encrypted with the specified server-side encryption type. For example, blocking an encryption type will block <code>PutObject</code>, <code>CopyObject</code>, <code>PostObject</code>, multipart upload, and replication requests to the bucket for objects with the specified encryption type. However, you can continue to read and list any pre-existing objects already encrypted with the specified encryption type. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/blocking-unblocking-s3-c-encryption-gpb.html">Blocking or unblocking SSE-C for a general purpose bucket</a>.</p>
/// <p>This data type is used with the following actions:</p>
/// <ul>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a></p></li>
/// </ul>
/// <dl>
/// <dt>
/// Permissions
/// </dt>
/// <dd>
/// <p>You must have the <code>s3:PutEncryptionConfiguration</code> permission to block or unblock an encryption type for a bucket.</p>
/// <p>You must have the <code>s3:GetEncryptionConfiguration</code> permission to view a bucket's encryption type.</p>
/// </dd>
/// </dl>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct BlockedEncryptionTypes {
    /// <p>The object encryption type that you want to block or unblock for an Amazon S3 general purpose bucket.</p><note>
    /// <p>Currently, this parameter only supports blocking or unblocking server side encryption with customer-provided keys (SSE-C). For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Using server-side encryption with customer-provided keys (SSE-C)</a>.</p>
    /// </note>
    pub encryption_type: ::std::option::Option<::std::vec::Vec<crate::types::EncryptionType>>,
}
impl BlockedEncryptionTypes {
    /// <p>The object encryption type that you want to block or unblock for an Amazon S3 general purpose bucket.</p><note>
    /// <p>Currently, this parameter only supports blocking or unblocking server side encryption with customer-provided keys (SSE-C). For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Using server-side encryption with customer-provided keys (SSE-C)</a>.</p>
    /// </note>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.encryption_type.is_none()`.
    pub fn encryption_type(&self) -> &[crate::types::EncryptionType] {
        self.encryption_type.as_deref().unwrap_or_default()
    }
}
impl BlockedEncryptionTypes {
    /// Creates a new builder-style object to manufacture [`BlockedEncryptionTypes`](crate::types::BlockedEncryptionTypes).
    pub fn builder() -> crate::types::builders::BlockedEncryptionTypesBuilder {
        crate::types::builders::BlockedEncryptionTypesBuilder::default()
    }
}

/// A builder for [`BlockedEncryptionTypes`](crate::types::BlockedEncryptionTypes).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct BlockedEncryptionTypesBuilder {
    pub(crate) encryption_type: ::std::option::Option<::std::vec::Vec<crate::types::EncryptionType>>,
}
impl BlockedEncryptionTypesBuilder {
    /// Appends an item to `encryption_type`.
    ///
    /// To override the contents of this collection use [`set_encryption_type`](Self::set_encryption_type).
    ///
    /// <p>The object encryption type that you want to block or unblock for an Amazon S3 general purpose bucket.</p><note>
    /// <p>Currently, this parameter only supports blocking or unblocking server side encryption with customer-provided keys (SSE-C). For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Using server-side encryption with customer-provided keys (SSE-C)</a>.</p>
    /// </note>
    pub fn encryption_type(mut self, input: crate::types::EncryptionType) -> Self {
        let mut v = self.encryption_type.unwrap_or_default();
        v.push(input);
        self.encryption_type = ::std::option::Option::Some(v);
        self
    }
    /// <p>The object encryption type that you want to block or unblock for an Amazon S3 general purpose bucket.</p><note>
    /// <p>Currently, this parameter only supports blocking or unblocking server side encryption with customer-provided keys (SSE-C). For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Using server-side encryption with customer-provided keys (SSE-C)</a>.</p>
    /// </note>
    pub fn set_encryption_type(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::EncryptionType>>) -> Self {
        self.encryption_type = input;
        self
    }
    /// <p>The object encryption type that you want to block or unblock for an Amazon S3 general purpose bucket.</p><note>
    /// <p>Currently, this parameter only supports blocking or unblocking server side encryption with customer-provided keys (SSE-C). For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Using server-side encryption with customer-provided keys (SSE-C)</a>.</p>
    /// </note>
    pub fn get_encryption_type(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::EncryptionType>> {
        &self.encryption_type
    }
    /// Consumes the builder and constructs a [`BlockedEncryptionTypes`](crate::types::BlockedEncryptionTypes).
    pub fn build(self) -> crate::types::BlockedEncryptionTypes {
        crate::types::BlockedEncryptionTypes {
            encryption_type: self.encryption_type,
        }
    }
}
