/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.net.SSLCertificateSocketFactory;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketMessage;
import de.tavendo.autobahn.WebSocketOptions;
import de.tavendo.autobahn.WebSocketReader;
import de.tavendo.autobahn.WebSocketWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.URI;
import javax.net.SocketFactory;

public class WebSocketConnection
implements WebSocket {
    private static final String TAG = WebSocketConnection.class.getName();
    private static final String WS_URI_SCHEME = "ws";
    private static final String WSS_URI_SCHEME = "wss";
    private static final String WS_WRITER = "WebSocketWriter";
    private static final String WS_READER = "WebSocketReader";
    private final Handler mHandler;
    private WebSocketReader mWebSocketReader;
    private WebSocketWriter mWebSocketWriter;
    private Socket mSocket;
    private SocketThread mSocketThread;
    private URI mWebSocketURI;
    private String[] mWebSocketSubprotocols;
    private WeakReference<WebSocket.WebSocketConnectionObserver> mWebSocketConnectionObserver;
    private WebSocketOptions mWebSocketOptions;
    private boolean mPreviousConnection = false;

    public WebSocketConnection() {
        Log.d((String)TAG, (String)"WebSocket connection created.");
        this.mHandler = new ThreadHandler(this);
    }

    @Override
    public void sendTextMessage(String payload) {
        this.mWebSocketWriter.forward(new WebSocketMessage.TextMessage(payload));
    }

    @Override
    public void sendRawTextMessage(byte[] payload) {
        this.mWebSocketWriter.forward(new WebSocketMessage.RawTextMessage(payload));
    }

    @Override
    public void sendBinaryMessage(byte[] payload) {
        this.mWebSocketWriter.forward(new WebSocketMessage.BinaryMessage(payload));
    }

    @Override
    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected() && !this.mSocket.isClosed();
    }

    private void failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, String reason) {
        Log.d((String)TAG, (String)("fail connection [code = " + (Object)((Object)code) + ", reason = " + reason));
        if (this.mWebSocketReader != null) {
            this.mWebSocketReader.quit();
            try {
                this.mWebSocketReader.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mReader already NULL");
        }
        if (this.mWebSocketWriter != null) {
            this.mWebSocketWriter.forward(new WebSocketMessage.Quit());
            try {
                this.mWebSocketWriter.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mWriter already NULL");
        }
        if (this.mSocket != null) {
            this.mSocketThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    WebSocketConnection.this.mSocketThread.stopConnection();
                }
            });
        } else {
            Log.d((String)TAG, (String)"mTransportChannel already NULL");
        }
        this.mSocketThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.onClose(code, reason);
        Log.d((String)TAG, (String)"worker threads stopped");
    }

    @Override
    public void connect(URI webSocketURI, WebSocket.WebSocketConnectionObserver connectionObserver) throws WebSocketException {
        this.connect(webSocketURI, connectionObserver, new WebSocketOptions());
    }

    @Override
    public void connect(URI webSocketURI, WebSocket.WebSocketConnectionObserver connectionObserver, WebSocketOptions options) throws WebSocketException {
        this.connect(webSocketURI, null, connectionObserver, options);
    }

    public void connect(URI webSocketURI, String[] subprotocols, WebSocket.WebSocketConnectionObserver connectionObserver, WebSocketOptions options) throws WebSocketException {
        if (this.isConnected()) {
            throw new WebSocketException("already connected");
        }
        if (webSocketURI == null) {
            throw new WebSocketException("WebSockets URI null.");
        }
        this.mWebSocketURI = webSocketURI;
        if (!this.mWebSocketURI.getScheme().equals(WS_URI_SCHEME) && !this.mWebSocketURI.getScheme().equals(WSS_URI_SCHEME)) {
            throw new WebSocketException("unsupported scheme for WebSockets URI");
        }
        this.mWebSocketSubprotocols = subprotocols;
        this.mWebSocketConnectionObserver = new WeakReference<WebSocket.WebSocketConnectionObserver>(connectionObserver);
        this.mWebSocketOptions = new WebSocketOptions(options);
        this.connect();
    }

    @Override
    public void disconnect() {
        if (this.mWebSocketWriter != null && this.mWebSocketWriter.isAlive()) {
            this.mWebSocketWriter.forward(new WebSocketMessage.Close());
        } else {
            Log.d((String)TAG, (String)"Could not send WebSocket Close .. writer already null");
        }
        this.mPreviousConnection = false;
    }

    public boolean reconnect() {
        if (!this.isConnected() && this.mWebSocketURI != null) {
            this.connect();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        this.mSocketThread = new SocketThread(this.mWebSocketURI, this.mWebSocketOptions);
        this.mSocketThread.start();
        SocketThread socketThread = this.mSocketThread;
        synchronized (socketThread) {
            try {
                this.mSocketThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mSocketThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                WebSocketConnection.this.mSocketThread.startConnection();
            }
        });
        socketThread = this.mSocketThread;
        synchronized (socketThread) {
            try {
                this.mSocketThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mSocket = this.mSocketThread.getSocket();
        if (this.mSocket == null) {
            this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT, this.mSocketThread.getFailureMessage());
        } else if (this.mSocket.isConnected()) {
            try {
                this.createReader();
                this.createWriter();
                WebSocketMessage.ClientHandshake clientHandshake = new WebSocketMessage.ClientHandshake(this.mWebSocketURI, null, this.mWebSocketSubprotocols);
                this.mWebSocketWriter.forward(clientHandshake);
            }
            catch (Exception e) {
                this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR, e.getLocalizedMessage());
            }
        } else {
            this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT, "could not connect to WebSockets server");
        }
    }

    protected boolean scheduleReconnect() {
        boolean shouldReconnect;
        int interval = this.mWebSocketOptions.getReconnectInterval();
        boolean bl = shouldReconnect = this.mSocket != null && this.mSocket.isConnected() && this.mPreviousConnection && interval > 0;
        if (shouldReconnect) {
            Log.d((String)TAG, (String)"WebSocket reconnection scheduled");
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TAG, (String)"WebSocket reconnecting...");
                    WebSocketConnection.this.reconnect();
                }
            }, (long)interval);
        }
        return shouldReconnect;
    }

    private void onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, String reason) {
        block6: {
            WebSocket.WebSocketConnectionObserver webSocketObserver;
            boolean reconnecting = false;
            if (code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT || code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST) {
                reconnecting = this.scheduleReconnect();
            }
            if ((webSocketObserver = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get()) != null) {
                try {
                    if (reconnecting) {
                        webSocketObserver.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.RECONNECT, reason);
                        break block6;
                    }
                    webSocketObserver.onClose(code, reason);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Log.d((String)TAG, (String)"WebSocketObserver null");
            }
        }
    }

    protected void processAppMessage(Object message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWriter() {
        this.mWebSocketWriter = new WebSocketWriter(this.mHandler, this.mSocket, this.mWebSocketOptions, WS_WRITER);
        this.mWebSocketWriter.start();
        WebSocketWriter webSocketWriter = this.mWebSocketWriter;
        synchronized (webSocketWriter) {
            try {
                this.mWebSocketWriter.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.d((String)TAG, (String)"WebSocket writer created and started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReader() {
        this.mWebSocketReader = new WebSocketReader(this.mHandler, this.mSocket, this.mWebSocketOptions, WS_READER);
        this.mWebSocketReader.start();
        WebSocketReader webSocketReader = this.mWebSocketReader;
        synchronized (webSocketReader) {
            try {
                this.mWebSocketReader.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.d((String)TAG, (String)"WebSocket reader created and started.");
    }

    private void handleMessage(Message message) {
        WebSocket.WebSocketConnectionObserver webSocketObserver = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get();
        if (message.obj instanceof WebSocketMessage.TextMessage) {
            WebSocketMessage.TextMessage textMessage = (WebSocketMessage.TextMessage)message.obj;
            if (webSocketObserver != null) {
                webSocketObserver.onTextMessage(textMessage.mPayload);
            } else {
                Log.d((String)TAG, (String)"could not call onTextMessage() .. handler already NULL");
            }
        } else if (message.obj instanceof WebSocketMessage.RawTextMessage) {
            WebSocketMessage.RawTextMessage rawTextMessage = (WebSocketMessage.RawTextMessage)message.obj;
            if (webSocketObserver != null) {
                webSocketObserver.onRawTextMessage(rawTextMessage.mPayload);
            } else {
                Log.d((String)TAG, (String)"could not call onRawTextMessage() .. handler already NULL");
            }
        } else if (message.obj instanceof WebSocketMessage.BinaryMessage) {
            WebSocketMessage.BinaryMessage binaryMessage = (WebSocketMessage.BinaryMessage)message.obj;
            if (webSocketObserver != null) {
                webSocketObserver.onBinaryMessage(binaryMessage.mPayload);
            } else {
                Log.d((String)TAG, (String)"could not call onBinaryMessage() .. handler already NULL");
            }
        } else if (message.obj instanceof WebSocketMessage.Ping) {
            WebSocketMessage.Ping ping = (WebSocketMessage.Ping)message.obj;
            Log.d((String)TAG, (String)"WebSockets Ping received");
            WebSocketMessage.Pong pong = new WebSocketMessage.Pong();
            pong.mPayload = ping.mPayload;
            this.mWebSocketWriter.forward(pong);
        } else if (message.obj instanceof WebSocketMessage.Pong) {
            WebSocketMessage.Pong pong = (WebSocketMessage.Pong)message.obj;
            Log.d((String)TAG, (String)("WebSockets Pong received" + pong.mPayload));
        } else if (message.obj instanceof WebSocketMessage.Close) {
            WebSocketMessage.Close close = (WebSocketMessage.Close)message.obj;
            Log.d((String)TAG, (String)("WebSockets Close received (" + close.getCode() + " - " + close.getReason() + ")"));
            this.mWebSocketWriter.forward(new WebSocketMessage.Close(1000));
        } else if (message.obj instanceof WebSocketMessage.ServerHandshake) {
            WebSocketMessage.ServerHandshake serverHandshake = (WebSocketMessage.ServerHandshake)message.obj;
            Log.d((String)TAG, (String)"opening handshake received");
            if (serverHandshake.mSuccess) {
                if (webSocketObserver != null) {
                    webSocketObserver.onOpen();
                } else {
                    Log.d((String)TAG, (String)"could not call onOpen() .. handler already NULL");
                }
                this.mPreviousConnection = true;
            }
        } else if (message.obj instanceof WebSocketMessage.ConnectionLost) {
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST, "WebSockets connection lost");
        } else if (message.obj instanceof WebSocketMessage.ProtocolViolation) {
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.PROTOCOL_ERROR, "WebSockets protocol violation");
        } else if (message.obj instanceof WebSocketMessage.Error) {
            WebSocketMessage.Error error = (WebSocketMessage.Error)message.obj;
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR, "WebSockets internal error (" + error.mException.toString() + ")");
        } else if (message.obj instanceof WebSocketMessage.ServerError) {
            WebSocketMessage.ServerError error = (WebSocketMessage.ServerError)message.obj;
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.SERVER_ERROR, "Server error " + error.mStatusCode + " (" + error.mStatusMessage + ")");
        } else {
            this.processAppMessage(message.obj);
        }
    }

    public static class SocketThread
    extends Thread {
        private static final String WS_CONNECTOR = "WebSocketConnector";
        private final URI mWebSocketURI;
        private Socket mSocket = null;
        private String mFailureMessage = null;
        private Handler mHandler;

        public SocketThread(URI uri, WebSocketOptions options) {
            this.setName(WS_CONNECTOR);
            this.mWebSocketURI = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            this.mHandler = new Handler();
            SocketThread socketThread = this;
            synchronized (socketThread) {
                this.notifyAll();
            }
            Looper.loop();
            Log.d((String)TAG, (String)"SocketThread exited.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startConnection() {
            try {
                String host = this.mWebSocketURI.getHost();
                int port = this.mWebSocketURI.getPort();
                if (port == -1) {
                    port = this.mWebSocketURI.getScheme().equals(WebSocketConnection.WSS_URI_SCHEME) ? 443 : 80;
                }
                SocketFactory factory = null;
                factory = this.mWebSocketURI.getScheme().equalsIgnoreCase(WebSocketConnection.WSS_URI_SCHEME) ? SSLCertificateSocketFactory.getDefault() : SocketFactory.getDefault();
                this.mSocket = factory.createSocket(host, port);
            }
            catch (IOException e) {
                this.mFailureMessage = e.getLocalizedMessage();
            }
            SocketThread socketThread = this;
            synchronized (socketThread) {
                this.notifyAll();
            }
        }

        public void stopConnection() {
            try {
                this.mSocket.close();
                this.mSocket = null;
            }
            catch (IOException e) {
                this.mFailureMessage = e.getLocalizedMessage();
            }
        }

        public Handler getHandler() {
            return this.mHandler;
        }

        public Socket getSocket() {
            return this.mSocket;
        }

        public String getFailureMessage() {
            return this.mFailureMessage;
        }
    }

    private static class ThreadHandler
    extends Handler {
        private final WeakReference<WebSocketConnection> mWebSocketConnection;

        public ThreadHandler(WebSocketConnection webSocketConnection) {
            this.mWebSocketConnection = new WeakReference<WebSocketConnection>(webSocketConnection);
        }

        public void handleMessage(Message message) {
            WebSocketConnection webSocketConnection = (WebSocketConnection)this.mWebSocketConnection.get();
            if (webSocketConnection != null) {
                webSocketConnection.handleMessage(message);
            }
        }
    }
}

