
use builtin;
use str;

set edit:completion:arg-completer[rage-keygen] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'rage-keygen'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'rage-keygen'= {
            cand -o 'Write the result to the file at path OUTPUT. Defaults to standard output.'
            cand --output 'Write the result to the file at path OUTPUT. Defaults to standard output.'
            cand -h 'Print this help message and exit.'
            cand --help 'Print this help message and exit.'
            cand -V 'Print version info and exit.'
            cand --version 'Print version info and exit.'
            cand -y 'Convert an identity file to a recipients file.'
        }
    ]
    $completions[$command]
}
