/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.ContextFreeContextHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020#H\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lorg/jetbrains/skiko/context/SoftwareContextHandler;", "Lorg/jetbrains/skiko/context/ContextFreeContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "isTransparentBackground", "", "colorModel", "Ljava/awt/image/ComponentColorModel;", "getColorModel", "()Ljava/awt/image/ComponentColorModel;", "storage", "Lorg/jetbrains/skia/Bitmap;", "getStorage", "()Lorg/jetbrains/skia/Bitmap;", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "imageData", "", "getImageData", "()[B", "setImageData", "([B)V", "raster", "Ljava/awt/image/WritableRaster;", "getRaster", "()Ljava/awt/image/WritableRaster;", "setRaster", "(Ljava/awt/image/WritableRaster;)V", "initCanvas", "", "flush", "skiko"})
public final class SoftwareContextHandler
extends ContextFreeContextHandler {
    @NotNull
    private final ComponentColorModel colorModel;
    @NotNull
    private final Bitmap storage;
    @Nullable
    private BufferedImage image;
    @Nullable
    private byte[] imageData;
    @Nullable
    private WritableRaster raster;

    public SoftwareContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
        this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        this.storage = new Bitmap();
    }

    @Override
    protected boolean isTransparentBackground() {
        return OsArch_jvmKt.getHostOs() == OS.MacOS && this.getLayer().getTransparency();
    }

    @NotNull
    public final ComponentColorModel getColorModel() {
        return this.colorModel;
    }

    @NotNull
    public final Bitmap getStorage() {
        return this.storage;
    }

    @Nullable
    public final BufferedImage getImage() {
        return this.image;
    }

    public final void setImage(@Nullable BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    @Nullable
    public final byte[] getImageData() {
        return this.imageData;
    }

    public final void setImageData(@Nullable byte[] byArray) {
        this.imageData = byArray;
    }

    @Nullable
    public final WritableRaster getRaster() {
        return this.raster;
    }

    public final void setRaster(@Nullable WritableRaster writableRaster) {
        this.raster = writableRaster;
    }

    @Override
    protected void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        if (this.storage.getWidth() != w || this.storage.getHeight() != h) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(w, h, ColorAlphaType.PREMUL), false);
        }
        this.setCanvas(new Canvas(this.storage, new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null)));
    }

    @Override
    protected void flush() {
        block4: {
            float scale = this.getLayer().getContentScale();
            int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
            int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
            byte[] bytes = this.storage.readPixels(this.storage.getImageInfo(), w * 4, 0, 0);
            if (bytes == null) break block4;
            DataBufferByte buffer = new DataBufferByte(bytes, bytes.length);
            int[] nArray = new int[]{2, 1, 0, 3};
            this.raster = Raster.createInterleavedRaster(buffer, w, h, w * 4, 4, nArray, null);
            ColorModel colorModel = this.colorModel;
            WritableRaster writableRaster = this.raster;
            Intrinsics.checkNotNull((Object)writableRaster);
            this.image = new BufferedImage(colorModel, writableRaster, false, null);
            Graphics graphics = this.getLayer().getBackedLayer$skiko().getGraphics();
            if (!this.getLayer().getFullscreen() && this.getLayer().getTransparency() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                Graphics graphics2 = graphics;
                if (graphics2 != null) {
                    graphics2.setColor(new Color(0, 0, 0, 0));
                }
                Graphics graphics3 = graphics;
                if (graphics3 != null) {
                    graphics3.clearRect(0, 0, w, h);
                }
            }
            Graphics graphics4 = graphics;
            if (graphics4 != null) {
                BufferedImage bufferedImage = this.image;
                Intrinsics.checkNotNull((Object)bufferedImage);
                graphics4.drawImage(bufferedImage, 0, 0, this.getLayer().getWidth(), this.getLayer().getHeight(), null);
            }
        }
    }
}

