/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.ebnf.PSystemEbnf;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandCommentMultilines
extends CommandMultilines2<PSystemEbnf> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^.*\\*\\)[%s]*$"));

    public CommandCommentMultilines() {
        super(CommandCommentMultilines.getRegexConcat(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH, END);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCommentMultilines.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(\\*"), new RegexLeaf(".*"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(PSystemEbnf diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        Display note = lines.removeFewChars(2).toDisplay();
        return diagram.addNote(note, null);
    }
}

