/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sigrok.core.classes;

/** Payload of a datafeed packet with analog data. */
public class Analog extends PacketPayload {
  protected transient long swigCPtr;
  protected transient boolean swigCMemOwnDerived;

  protected Analog(long cPtr, boolean cMemoryOwn) {
    super(classesJNI.Analog_SWIGSmartPtrUpcast(cPtr), true);
    swigCMemOwnDerived = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Analog obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void swigSetCMemOwn(boolean own) {
    swigCMemOwnDerived = own;
    super.swigSetCMemOwn(own);
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwnDerived) {
        swigCMemOwnDerived = false;
        classesJNI.delete_Analog(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /** Pointer to data. */
public SWIGTYPE_p_void data_pointer() {
    long cPtr = classesJNI.Analog_data_pointer(swigCPtr, this);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /** Fills dest pointer with the analog data converted to float. */
public void get_data_as_float(SWIGTYPE_p_float dest) {
    classesJNI.Analog_get_data_as_float(swigCPtr, this, SWIGTYPE_p_float.getCPtr(dest));
  }

  /** Number of samples in this packet. */
public long num_samples() {
    return classesJNI.Analog_num_samples(swigCPtr, this);
  }

  /** Channels for which this packet contains data. */
public java.util.Vector<Channel> channels() {
  return (java.util.Vector<Channel>)classesJNI.Analog_channels(swigCPtr, this);
}

  /** Size of a single sample in bytes. */
public long unitsize() {
    return classesJNI.Analog_unitsize(swigCPtr, this);
  }

  /** Samples use a signed data type. */
public boolean is_signed() {
    return classesJNI.Analog_is_signed(swigCPtr, this);
  }

  /** Samples use float. */
public boolean is_float() {
    return classesJNI.Analog_is_float(swigCPtr, this);
  }

  /** Samples are stored in big-endian order. */
public boolean is_bigendian() {
    return classesJNI.Analog_is_bigendian(swigCPtr, this);
  }

  /** Number of significant digits after the decimal point if positive, or number of non-significant digits before the decimal point if negative (refers to the value we actually read on the wire). */
public int digits() {
    return classesJNI.Analog_digits(swigCPtr, this);
  }

  /** TBD. */
public boolean is_digits_decimal() {
    return classesJNI.Analog_is_digits_decimal(swigCPtr, this);
  }

  /** TBD. */
public SWIGTYPE_p_std__shared_ptrT_sigrok__Rational_t scale() {
    return new SWIGTYPE_p_std__shared_ptrT_sigrok__Rational_t(classesJNI.Analog_scale(swigCPtr, this), true);
  }

  /** TBD. */
public SWIGTYPE_p_std__shared_ptrT_sigrok__Rational_t offset() {
    return new SWIGTYPE_p_std__shared_ptrT_sigrok__Rational_t(classesJNI.Analog_offset(swigCPtr, this), true);
  }

  /** Measured quantity of the samples in this packet. */
public Quantity mq() {
    long cPtr = classesJNI.Analog_mq(swigCPtr, this);
    return (cPtr == 0) ? null : new Quantity(cPtr, false);
  }

  /** Unit of the samples in this packet. */
public Unit unit() {
    long cPtr = classesJNI.Analog_unit(swigCPtr, this);
    return (cPtr == 0) ? null : new Unit(cPtr, false);
  }

  /** Measurement flags associated with the samples in this packet. */
public QuantityFlagVector mq_flags() {
    return new QuantityFlagVector(classesJNI.Analog_mq_flags(swigCPtr, this), true);
  }

  /** Provides a Logic packet that contains a conversion of the analog data using a simple threshold.
   * @param threshold Threshold to use.
   * @param data_ptr Pointer to num_samples() bytes where the logic samples are stored. When nullptr, memory for logic->data_pointer() will be allocated and must be freed by the caller. */
public Logic get_logic_via_threshold(float threshold, SWIGTYPE_p_uint8_t data_ptr) {
    long cPtr = classesJNI.Analog_get_logic_via_threshold__SWIG_0(swigCPtr, this, threshold, SWIGTYPE_p_uint8_t.getCPtr(data_ptr));
    return (cPtr == 0) ? null : new Logic(cPtr, true);
  }

  /** Provides a Logic packet that contains a conversion of the analog data using a simple threshold.
   * @param threshold Threshold to use.
   * @param data_ptr Pointer to num_samples() bytes where the logic samples are stored. When nullptr, memory for logic->data_pointer() will be allocated and must be freed by the caller. */
public Logic get_logic_via_threshold(float threshold) {
    long cPtr = classesJNI.Analog_get_logic_via_threshold__SWIG_1(swigCPtr, this, threshold);
    return (cPtr == 0) ? null : new Logic(cPtr, true);
  }

  /** Provides a Logic packet that contains a conversion of the analog data using a Schmitt-Trigger.
   * @param lo_thr Low threshold to use (anything below this is low).
   * @param hi_thr High threshold to use (anything above this is high).
   * @param state Points to a byte that contains the current state of the converter. For best results, set to value of logic sample n-1.
   * @param data_ptr Pointer to num_samples() bytes where the logic samples are stored. When nullptr, memory for logic->data_pointer() will be allocated and must be freed by the caller. */
public Logic get_logic_via_schmitt_trigger(float lo_thr, float hi_thr, SWIGTYPE_p_uint8_t state, SWIGTYPE_p_uint8_t data_ptr) {
    long cPtr = classesJNI.Analog_get_logic_via_schmitt_trigger__SWIG_0(swigCPtr, this, lo_thr, hi_thr, SWIGTYPE_p_uint8_t.getCPtr(state), SWIGTYPE_p_uint8_t.getCPtr(data_ptr));
    return (cPtr == 0) ? null : new Logic(cPtr, true);
  }

  /** Provides a Logic packet that contains a conversion of the analog data using a Schmitt-Trigger.
   * @param lo_thr Low threshold to use (anything below this is low).
   * @param hi_thr High threshold to use (anything above this is high).
   * @param state Points to a byte that contains the current state of the converter. For best results, set to value of logic sample n-1.
   * @param data_ptr Pointer to num_samples() bytes where the logic samples are stored. When nullptr, memory for logic->data_pointer() will be allocated and must be freed by the caller. */
public Logic get_logic_via_schmitt_trigger(float lo_thr, float hi_thr, SWIGTYPE_p_uint8_t state) {
    long cPtr = classesJNI.Analog_get_logic_via_schmitt_trigger__SWIG_1(swigCPtr, this, lo_thr, hi_thr, SWIGTYPE_p_uint8_t.getCPtr(state));
    return (cPtr == 0) ? null : new Logic(cPtr, true);
  }

}
