/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmJsonExistsExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonExistsFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    protected final boolean supportsJsonPathExpression;
    protected final boolean supportsJsonPathPassingClause;

    public JsonExistsFunction(TypeConfiguration typeConfiguration, boolean supportsJsonPathExpression, boolean supportsJsonPathPassingClause) {
        super("json_exists", FunctionKind.NORMAL, new ArgumentTypesValidator(null, FunctionParameterType.IMPLICIT_JSON, FunctionParameterType.STRING), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.standardBasicTypeForJavaType(Boolean.class)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.JSON, FunctionParameterType.STRING));
        this.supportsJsonPathExpression = supportsJsonPathExpression;
        this.supportsJsonPathPassingClause = supportsJsonPathPassingClause;
    }

    @Override
    public boolean isPredicate() {
        return true;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new SqmJsonExistsExpression((SqmFunctionDescriptor)this, (FunctionRenderer)this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, JsonExistsArguments.extract(sqlAstArguments), returnType, walker);
    }

    protected void render(SqlAppender sqlAppender, JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        JsonExistsErrorBehavior errorBehavior;
        sqlAppender.appendSql("json_exists(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(',');
        Expression jsonPath = arguments.jsonPath();
        JsonPathPassingClause passingClause = arguments.passingClause();
        if (this.supportsJsonPathPassingClause || passingClause == null) {
            if (this.supportsJsonPathExpression) {
                jsonPath.accept(walker);
            } else {
                walker.getSessionFactory().getJdbcServices().getDialect().appendLiteral(sqlAppender, (String)walker.getLiteralValue(jsonPath));
            }
            if (passingClause != null) {
                sqlAppender.appendSql(" passing ");
                Map<String, Expression> passingExpressions = passingClause.getPassingExpressions();
                Iterator<Map.Entry<String, Expression>> iterator = passingExpressions.entrySet().iterator();
                Map.Entry<String, Expression> entry = iterator.next();
                entry.getValue().accept(walker);
                sqlAppender.appendSql(" as ");
                sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sqlAppender.appendSql(',');
                    entry.getValue().accept(walker);
                    sqlAppender.appendSql(" as ");
                    sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                }
            }
        } else {
            JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
        }
        if ((errorBehavior = arguments.errorBehavior()) != null && errorBehavior != JsonExistsErrorBehavior.FALSE) {
            if (errorBehavior == JsonExistsErrorBehavior.TRUE) {
                sqlAppender.appendSql(" true on error");
            } else {
                sqlAppender.appendSql(" error on error");
            }
        }
        sqlAppender.appendSql(')');
    }

    protected record JsonExistsArguments(Expression jsonDocument, Expression jsonPath, boolean isJsonType, @Nullable JsonPathPassingClause passingClause, @Nullable JsonExistsErrorBehavior errorBehavior) {
        public static JsonExistsArguments extract(List<? extends SqlAstNode> sqlAstArguments) {
            SqlAstNode node;
            int nextIndex = 2;
            JsonPathPassingClause passingClause = null;
            JsonExistsErrorBehavior errorBehavior = null;
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonPathPassingClause) {
                JsonPathPassingClause pathPassingClause;
                passingClause = pathPassingClause = (JsonPathPassingClause)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonExistsErrorBehavior) {
                JsonExistsErrorBehavior existsErrorBehavior;
                errorBehavior = existsErrorBehavior = (JsonExistsErrorBehavior)node;
                ++nextIndex;
            }
            Expression jsonDocument = (Expression)sqlAstArguments.get(0);
            return new JsonExistsArguments(jsonDocument, (Expression)sqlAstArguments.get(1), jsonDocument.getExpressionType() != null && jsonDocument.getExpressionType().getSingleJdbcMapping().getJdbcType().isJson(), passingClause, errorBehavior);
        }
    }
}

