/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal;

import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ResultsHelper {
    public static int jdbcPositionToValuesArrayPosition(int jdbcPosition) {
        return jdbcPosition - 1;
    }

    public static int valuesArrayPositionToJdbcPosition(int valuesArrayPosition) {
        return valuesArrayPosition + 1;
    }

    public static DomainResultCreationStateImpl impl(DomainResultCreationState creationState) {
        return ResultsHelper.unwrap(creationState);
    }

    private static DomainResultCreationStateImpl unwrap(DomainResultCreationState creationState) {
        if (creationState instanceof DomainResultCreationStateImpl) {
            DomainResultCreationStateImpl domainResultCreationState = (DomainResultCreationStateImpl)creationState;
            return domainResultCreationState;
        }
        throw new IllegalArgumentException("Passed DomainResultCreationState not an instance of org.hibernate.query.results.internal.DomainResultCreationStateImpl");
    }

    public static Expression resolveSqlExpression(DomainResultCreationStateImpl resolver, JdbcValuesMetadata jdbcValuesMetadata, TableReference tableReference, SelectableMapping selectableMapping, String columnAlias) {
        return resolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping), processingState -> {
            int jdbcPosition = jdbcValuesMetadata.resolveColumnPosition(columnAlias);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, selectableMapping.getJdbcMapping());
        });
    }

    public static Expression resolveSqlExpression(DomainResultCreationStateImpl resolver, JdbcValuesMetadata jdbcValuesMetadata, TableReference tableReference, EntityDiscriminatorMapping discriminatorMapping, String columnAlias) {
        return resolver.resolveSqlExpression(SqlExpressionResolver.createDiscriminatorColumnReferenceKey(tableReference, discriminatorMapping), processingState -> {
            int jdbcPosition = jdbcValuesMetadata.resolveColumnPosition(columnAlias);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, discriminatorMapping.getJdbcMapping());
        });
    }

    public static Expression resolveSqlExpression(DomainResultCreationStateImpl resolver, TableReference tableReference, SelectableMapping selectableMapping, int valuesArrayPosition) {
        return resolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectablePath(), selectableMapping.getJdbcMapping()), processingState -> new ResultSetMappingSqlSelection(valuesArrayPosition, selectableMapping.getJdbcMapping()));
    }

    private ResultsHelper() {
    }

    public static String attributeName(ModelPart identifierMapping) {
        if (identifierMapping.isEntityIdentifierMapping()) {
            String string;
            if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
                SingleAttributeIdentifierMapping singleAttributeIdentifierMapping = (SingleAttributeIdentifierMapping)identifierMapping;
                string = singleAttributeIdentifierMapping.getAttributeName();
            } else {
                string = null;
            }
            return string;
        }
        return identifierMapping.getPartName();
    }
}

