/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;

public class QuarkusHttpUser
implements User {
    public static final String DEFERRED_IDENTITY_KEY = "io.quarkus.vertx.http.deferred-identity";
    public static final String AUTH_FAILURE_HANDLER = "io.quarkus.vertx.http.auth-failure-handler";
    private final SecurityIdentity securityIdentity;

    public QuarkusHttpUser(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    public JsonObject attributes() {
        return this.principal();
    }

    public User isAuthorized(Authorization authority, Handler<AsyncResult<Boolean>> resultHandler) {
        return null;
    }

    @Deprecated
    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.securityIdentity.hasRole(authority)));
        return this;
    }

    @Deprecated
    public User clearCache() {
        return this;
    }

    public JsonObject principal() {
        JsonObject ret = new JsonObject();
        ret.put("username", (Object)this.securityIdentity.getPrincipal().getName());
        return ret;
    }

    @Deprecated
    public void setAuthProvider(AuthProvider authProvider) {
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public static SecurityIdentity getSecurityIdentityBlocking(RoutingContext routingContext, IdentityProviderManager identityProviderManager) {
        QuarkusHttpUser existing = (QuarkusHttpUser)routingContext.user();
        if (existing != null) {
            return existing.getSecurityIdentity();
        }
        Uni deferred = (Uni)routingContext.get(DEFERRED_IDENTITY_KEY);
        if (deferred != null) {
            return (SecurityIdentity)deferred.await().indefinitely();
        }
        if (identityProviderManager != null) {
            return (SecurityIdentity)identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new AnonymousAuthenticationRequest(), routingContext)).await().indefinitely();
        }
        return null;
    }

    public User merge(User other) {
        if (other == null) {
            return this;
        }
        this.principal().mergeIn(other.principal());
        return this;
    }

    public static Uni<SecurityIdentity> getSecurityIdentity(RoutingContext routingContext, IdentityProviderManager identityProviderManager) {
        Uni deferred = (Uni)routingContext.get(DEFERRED_IDENTITY_KEY);
        if (deferred != null) {
            return deferred;
        }
        QuarkusHttpUser existing = (QuarkusHttpUser)routingContext.user();
        if (existing != null) {
            return Uni.createFrom().item((Object)existing.getSecurityIdentity());
        }
        if (identityProviderManager != null) {
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new AnonymousAuthenticationRequest(), routingContext));
        }
        return Uni.createFrom().nullItem();
    }

    static Uni<SecurityIdentity> setIdentity(Uni<SecurityIdentity> identityUni, RoutingContext routingContext) {
        routingContext.setUser(null);
        routingContext.put(DEFERRED_IDENTITY_KEY, identityUni);
        return identityUni;
    }

    public static SecurityIdentity setIdentity(SecurityIdentity identity, RoutingContext routingContext) {
        routingContext.setUser((User)new QuarkusHttpUser(identity));
        routingContext.put(DEFERRED_IDENTITY_KEY, (Object)Uni.createFrom().item((Object)identity));
        return identity;
    }
}

