/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.performanceTesting.remoteDriver.compose;

import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.text.AnnotatedString;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/performanceTesting/remoteDriver/compose/ComposeSemanticsNodeWrapper;", "Ljava/awt/Component;", "node", "Landroidx/compose/ui/semantics/SemanticsNode;", "panel", "Landroidx/compose/ui/awt/ComposePanel;", "<init>", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/awt/ComposePanel;)V", "scale", "", "getLocationOnScreen", "Ljava/awt/Point;", "getSize", "Ljava/awt/Dimension;", "getX", "", "getY", "getWidth", "getHeight", "isShowing", "", "isVisible", "toString", "", "intellij.performanceTesting.remoteDriver.compose"})
@SourceDebugExtension(value={"SMAP\nComposeXpathDataModelExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeXpathDataModelExtension.kt\ncom/intellij/performanceTesting/remoteDriver/compose/ComposeSemanticsNodeWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 6 Rect.kt\nandroidx/compose/ui/geometry/Rect\n*L\n1#1,193:1\n1#2:194\n57#3:195\n61#3:198\n60#4:196\n70#4:199\n22#5:197\n57#6:200\n62#6:201\n*S KotlinDebug\n*F\n+ 1 ComposeXpathDataModelExtension.kt\ncom/intellij/performanceTesting/remoteDriver/compose/ComposeSemanticsNodeWrapper\n*L\n42#1:195\n42#1:198\n42#1:196\n42#1:199\n42#1:197\n54#1:200\n58#1:201\n*E\n"})
final class ComposeSemanticsNodeWrapper
extends Component {
    @NotNull
    private final SemanticsNode node;
    @NotNull
    private final ComposePanel panel;
    private final float scale;

    public ComposeSemanticsNodeWrapper(@NotNull SemanticsNode node, @NotNull ComposePanel panel) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        this.node = node;
        this.panel = panel;
        this.scale = JBUIScale.sysScale((Component)((Component)this.panel));
    }

    @Override
    @NotNull
    public Point getLocationOnScreen() {
        Rect bounds = this.node.getBoundsInRoot();
        return new Point((int)(bounds.getLeft() / this.scale) + this.panel.getLocationOnScreen().x, (int)(bounds.getTop() / this.scale) + this.panel.getLocationOnScreen().y);
    }

    @Override
    @NotNull
    public Dimension getSize() {
        long it = this.node.getBoundsInWindow().getSize-NH-jbRc();
        boolean bl = false;
        long l2 = it;
        boolean bl2 = false;
        long value$iv$iv = l2;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        int n = (int)(Float.intBitsToFloat(bits$iv$iv$iv) / this.scale);
        l2 = it;
        boolean bl3 = false;
        value$iv$iv = l2;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        return new Dimension(n, (int)(Float.intBitsToFloat(bits$iv$iv$iv) / this.scale));
    }

    @Override
    public int getX() {
        return (int)(this.node.getBoundsInWindow().getLeft() / this.scale);
    }

    @Override
    public int getY() {
        return (int)(this.node.getBoundsInWindow().getTop() / this.scale);
    }

    @Override
    public int getWidth() {
        Rect this_$iv = this.node.getBoundsInWindow();
        boolean $i$f$getWidth = false;
        return (int)((this_$iv.getRight() - this_$iv.getLeft()) / this.scale);
    }

    @Override
    public int getHeight() {
        Rect this_$iv = this.node.getBoundsInWindow();
        boolean $i$f$getHeight = false;
        return (int)((this_$iv.getBottom() - this_$iv.getTop()) / this.scale);
    }

    @Override
    public boolean isShowing() {
        return this.panel.isShowing() && SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)this.node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getDisabled()) == null;
    }

    @Override
    public boolean isVisible() {
        return this.panel.isVisible() && SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)this.node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getDisabled()) == null;
    }

    @Override
    @NotNull
    public String toString() {
        List list = (List)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)this.node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getText());
        String text = list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, ComposeSemanticsNodeWrapper::toString$lambda$0, (int)31, null) : null;
        Role role = (Role)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)this.node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getRole());
        return "ComposeSemanticsNode(role=" + role + ", text=" + text + ")";
    }

    private static final CharSequence toString$lambda$0(AnnotatedString it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }
}

