/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.LocalPathPrefixComposer;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

public abstract class LocalPathPrefixComposerFactorySupport
implements LocalPathPrefixComposerFactory {
    protected boolean isSplit(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, "aether.enhancedLocalRepository.split");
    }

    protected String getLocalPrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, "installed", "aether.enhancedLocalRepository.localPrefix");
    }

    protected boolean isSplitLocal(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, "aether.enhancedLocalRepository.splitLocal");
    }

    protected String getRemotePrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, "cached", "aether.enhancedLocalRepository.remotePrefix");
    }

    protected boolean isSplitRemote(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, "aether.enhancedLocalRepository.splitRemote");
    }

    protected boolean isSplitRemoteRepository(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, "aether.enhancedLocalRepository.splitRemoteRepository");
    }

    protected boolean isSplitRemoteRepositoryLast(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, "aether.enhancedLocalRepository.splitRemoteRepositoryLast");
    }

    protected String getReleasesPrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, "releases", "aether.enhancedLocalRepository.releasesPrefix");
    }

    protected String getSnapshotsPrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, "snapshots", "aether.enhancedLocalRepository.snapshotsPrefix");
    }

    protected static abstract class LocalPathPrefixComposerSupport
    implements LocalPathPrefixComposer {
        protected final boolean split;
        protected final String localPrefix;
        protected final boolean splitLocal;
        protected final String remotePrefix;
        protected final boolean splitRemote;
        protected final boolean splitRemoteRepository;
        protected final boolean splitRemoteRepositoryLast;
        protected final String releasesPrefix;
        protected final String snapshotsPrefix;

        protected LocalPathPrefixComposerSupport(boolean split, String localPrefix, boolean splitLocal, String remotePrefix, boolean splitRemote, boolean splitRemoteRepository, boolean splitRemoteRepositoryLast, String releasesPrefix, String snapshotsPrefix) {
            this.split = split;
            this.localPrefix = localPrefix;
            this.splitLocal = splitLocal;
            this.remotePrefix = remotePrefix;
            this.splitRemote = splitRemote;
            this.splitRemoteRepository = splitRemoteRepository;
            this.splitRemoteRepositoryLast = splitRemoteRepositoryLast;
            this.releasesPrefix = releasesPrefix;
            this.snapshotsPrefix = snapshotsPrefix;
        }

        @Override
        public String getPathPrefixForLocalArtifact(Artifact artifact) {
            if (!this.split) {
                return null;
            }
            String result = this.localPrefix;
            if (this.splitLocal) {
                result = result + "/" + (artifact.isSnapshot() ? this.snapshotsPrefix : this.releasesPrefix);
            }
            return result;
        }

        @Override
        public String getPathPrefixForRemoteArtifact(Artifact artifact, RemoteRepository repository) {
            if (!this.split) {
                return null;
            }
            String result = this.remotePrefix;
            if (!this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            if (this.splitRemote) {
                result = result + "/" + (artifact.isSnapshot() ? this.snapshotsPrefix : this.releasesPrefix);
            }
            if (this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            return result;
        }

        @Override
        public String getPathPrefixForLocalMetadata(Metadata metadata) {
            if (!this.split) {
                return null;
            }
            String result = this.localPrefix;
            if (this.splitLocal) {
                result = result + "/" + (this.isSnapshot(metadata) ? this.snapshotsPrefix : this.releasesPrefix);
            }
            return result;
        }

        @Override
        public String getPathPrefixForRemoteMetadata(Metadata metadata, RemoteRepository repository) {
            if (!this.split) {
                return null;
            }
            String result = this.remotePrefix;
            if (!this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            if (this.splitRemote) {
                result = result + "/" + (this.isSnapshot(metadata) ? this.snapshotsPrefix : this.releasesPrefix);
            }
            if (this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            return result;
        }

        protected boolean isSnapshot(Metadata metadata) {
            return !metadata.getVersion().isEmpty() && metadata.getVersion().endsWith("-SNAPSHOT");
        }
    }
}

