/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class ConstExprent
extends Exprent {
    private static final String SHORT_SIG = "java/lang/Short";
    private static final String INT_SIG = "java/lang/Integer";
    private static final String LONG_SIG = "java/lang/Long";
    private static final String FLOAT_SIG = "java/lang/Float";
    private static final String DOUBLE_SIG = "java/lang/Double";
    private static final String MATH_SIG = "java/lang/Math";
    private static final String MIN_VAL = "MIN_VALUE";
    private static final String MAX_VAL = "MAX_VALUE";
    private static final String POS_INF = "POSITIVE_INFINITY";
    private static final String NEG_INF = "NEGATIVE_INFINITY";
    private static final String NAN = "NaN";
    private static final String MIN_NORM = "MIN_NORMAL";
    private static final String E = "E";
    private static final String PI = "PI";
    private static final Map<Integer, String> CHAR_ESCAPES = Map.of(8, "\\b", 9, "\\t", 10, "\\n", 12, "\\f", 13, "\\r", 39, "\\'", 92, "\\\\");
    private StructMember parent;
    private static final Map<Double, String[]> PI_DOUBLES = new HashMap<Double, String[]>();
    private static final Map<Float, String[]> PI_FLOATS = new HashMap<Float, String[]>();
    private static final Map<Float, String> FLOAT_CONSTANTS = new HashMap<Float, String>();
    private static final Map<Double, String> DOUBLE_CONSTANTS = new HashMap<Double, String>();
    @NotNull
    private VarType constType;
    private final Object value;
    private final boolean boolPermitted;

    public ConstExprent(int val, boolean boolPermitted, BitSet bytecodeOffsets) {
        this(ConstExprent.guessType(val, boolPermitted), (Object)val, boolPermitted, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, BitSet bytecodeOffsets) {
        this(constType, value, false, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, BitSet bytecodeOffsets, StructMember parent) {
        this(constType, value, bytecodeOffsets);
        this.parent = parent;
    }

    private ConstExprent(VarType constType, Object value, boolean boolPermitted, BitSet bytecodeOffsets) {
        super(3);
        this.constType = constType == null ? VarType.VARTYPE_UNKNOWN : constType;
        this.value = value;
        this.boolPermitted = boolPermitted;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private static VarType guessType(int val, boolean boolPermitted) {
        if (boolPermitted) {
            VarType constType = VarType.VARTYPE_BOOLEAN;
            if (val != 0 && val != 1) {
                constType = constType.copy(true);
            }
            return constType;
        }
        if (0 <= val && val <= 127) {
            return VarType.VARTYPE_BYTECHAR;
        }
        if (-128 <= val && val <= 127) {
            return VarType.VARTYPE_BYTE;
        }
        if (0 <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORTCHAR;
        }
        if (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORT;
        }
        if (0 <= val && val <= 65535) {
            return VarType.VARTYPE_CHAR;
        }
        return VarType.VARTYPE_INT;
    }

    @Override
    public Exprent copy() {
        return new ConstExprent(this.constType, this.value, this.bytecode);
    }

    @Override
    @NotNull
    public VarType getExprType() {
        VarType varType = this.constType;
        if (varType == null) {
            ConstExprent.$$$reportNull$$$0(0);
        }
        return varType;
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> list) {
        return list;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        boolean literal = DecompilerContext.getOption("lit");
        boolean ascii = DecompilerContext.getOption("asc");
        tracer.addMapping(this.bytecode);
        if (this.constType.getType() != 13 && this.value == null) {
            return new TextBuffer(ExprProcessor.getCastTypeName(this.constType, Collections.emptyList()));
        }
        return switch (this.constType.getType()) {
            case 7 -> new TextBuffer(Boolean.toString((Integer)this.value != 0));
            case 1 -> {
                Integer val = (Integer)this.value;
                String ret = CHAR_ESCAPES.get(val);
                if (ret == null) {
                    char c = (char)val.intValue();
                    ret = ConstExprent.isPrintableAscii(c) || !ascii && TextUtil.isPrintableUnicode(c) ? String.valueOf(c) : TextUtil.charToUnicodeLiteral(c);
                }
                yield new TextBuffer(ret).enclose("'", "'");
            }
            case 0 -> new TextBuffer(this.value.toString());
            case 6, 15 -> {
                int shortVal = (Integer)this.value;
                if (!literal) {
                    if (shortVal == Short.MAX_VALUE && !this.inConstantVariable(SHORT_SIG, MAX_VAL)) {
                        yield new FieldExprent(MAX_VAL, SHORT_SIG, true, null, FieldDescriptor.SHORT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (shortVal == Short.MIN_VALUE && !this.inConstantVariable(SHORT_SIG, MIN_VAL)) {
                        yield new FieldExprent(MIN_VAL, SHORT_SIG, true, null, FieldDescriptor.SHORT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                yield new TextBuffer(this.value.toString());
            }
            case 4, 16 -> {
                int intVal = (Integer)this.value;
                if (!literal) {
                    if (intVal == Integer.MAX_VALUE && !this.inConstantVariable(INT_SIG, MAX_VAL)) {
                        yield new FieldExprent(MAX_VAL, INT_SIG, true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (intVal == Integer.MIN_VALUE && !this.inConstantVariable(INT_SIG, MIN_VAL)) {
                        yield new FieldExprent(MIN_VAL, INT_SIG, true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                yield new TextBuffer(this.value.toString());
            }
            case 5 -> {
                long longVal = (Long)this.value;
                if (!literal) {
                    if (longVal == Long.MAX_VALUE && !this.inConstantVariable(LONG_SIG, MAX_VAL)) {
                        yield new FieldExprent(MAX_VAL, LONG_SIG, true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (longVal == Long.MIN_VALUE && !this.inConstantVariable(LONG_SIG, MIN_VAL)) {
                        yield new FieldExprent(MIN_VAL, LONG_SIG, true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                yield new TextBuffer(this.value.toString()).append('L');
            }
            case 3 -> this.createFloat(literal, ((Float)this.value).floatValue(), tracer);
            case 2 -> {
                TextBuffer floatBuffer;
                float nearestFloatVal;
                double doubleVal = (Double)this.value;
                boolean withSuffix = DecompilerContext.getOption("sfn");
                if (!literal) {
                    if (Double.isNaN(doubleVal) && !this.inConstantVariable(DOUBLE_SIG, NAN)) {
                        yield new FieldExprent(NAN, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY && !this.inConstantVariable(DOUBLE_SIG, POS_INF)) {
                        yield new FieldExprent(POS_INF, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY && !this.inConstantVariable(DOUBLE_SIG, NEG_INF)) {
                        yield new FieldExprent(NEG_INF, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MAX_VALUE && !this.inConstantVariable(DOUBLE_SIG, MAX_VAL)) {
                        yield new FieldExprent(MAX_VAL, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MIN_VALUE && !this.inConstantVariable(DOUBLE_SIG, MIN_VAL)) {
                        yield new FieldExprent(MIN_VAL, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MIN_NORMAL && !this.inConstantVariable(DOUBLE_SIG, MIN_NORM)) {
                        yield new FieldExprent(MIN_NORM, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Math.E && !this.inConstantVariable(MATH_SIG, E)) {
                        yield new FieldExprent(E, MATH_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == -1.7976931348623157E308 && !this.inConstantVariable(DOUBLE_SIG, MAX_VAL)) {
                        yield new FieldExprent(MAX_VAL, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
                    }
                    if (doubleVal == -2.2250738585072014E-308) {
                        yield new FieldExprent(MIN_NORM, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
                    }
                    if (doubleVal == -4.9E-324) {
                        yield new FieldExprent(MIN_VAL, DOUBLE_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
                    }
                    if (PI_DOUBLES.containsKey(doubleVal)) {
                        String[] parts = PI_DOUBLES.get(doubleVal);
                        yield this.getPiDouble(tracer).enclose(parts[0], parts[1]);
                    }
                    if (DOUBLE_CONSTANTS.containsKey(doubleVal)) {
                        yield new TextBuffer(DOUBLE_CONSTANTS.get(doubleVal));
                    }
                } else {
                    if (Double.isNaN(doubleVal)) {
                        if (withSuffix) {
                            yield new TextBuffer("0.0D / 0.0D");
                        }
                        yield new TextBuffer("0.0 / 0.0");
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY) {
                        if (withSuffix) {
                            yield new TextBuffer("1.0D / 0.0D");
                        }
                        yield new TextBuffer("1.0 / 0.0");
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY) {
                        if (withSuffix) {
                            yield new TextBuffer("-1.0D / 0.0D");
                        }
                        yield new TextBuffer("-1.0 / 0.0");
                    }
                }
                TextBuffer doubleBuffer = new TextBuffer(ConstExprent.trimDouble(Double.toString(doubleVal), doubleVal));
                if (withSuffix) {
                    doubleBuffer = doubleBuffer.append('D');
                }
                if (!literal && doubleVal == (double)(nearestFloatVal = (float)doubleVal) && (floatBuffer = this.createFloat(literal, nearestFloatVal, tracer)).length() != doubleBuffer.length()) {
                    yield floatBuffer.prepend("(double)");
                }
                yield doubleBuffer;
            }
            case 13 -> new TextBuffer("null");
            case 8 -> {
                if (this.constType.equals(VarType.VARTYPE_STRING)) {
                    yield new TextBuffer(ConstExprent.convertStringToJava(this.value.toString(), ascii)).enclose("\"", "\"");
                }
                if (this.constType.equals(VarType.VARTYPE_CLASS)) {
                    String stringVal;
                    VarType type = new VarType(stringVal, !(stringVal = this.value.toString()).startsWith("["));
                    yield new TextBuffer(ExprProcessor.getCastTypeName(type, Collections.emptyList())).append(".class");
                }
                throw new RuntimeException("invalid constant type: " + String.valueOf(this.constType));
            }
            default -> throw new RuntimeException("invalid constant type: " + String.valueOf(this.constType));
        };
    }

    private TextBuffer createFloat(boolean literal, float floatVal, BytecodeMappingTracer tracer) {
        if (!literal) {
            if (Float.isNaN(floatVal) && !this.inConstantVariable(FLOAT_SIG, NAN)) {
                return new FieldExprent(NAN, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.POSITIVE_INFINITY && !this.inConstantVariable(FLOAT_SIG, POS_INF)) {
                return new FieldExprent(POS_INF, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.NEGATIVE_INFINITY && !this.inConstantVariable(FLOAT_SIG, NEG_INF)) {
                return new FieldExprent(NEG_INF, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.MAX_VALUE && !this.inConstantVariable(FLOAT_SIG, MAX_VAL)) {
                return new FieldExprent(MAX_VAL, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.MIN_NORMAL && !this.inConstantVariable(FLOAT_SIG, MIN_NORM)) {
                return new FieldExprent(MIN_NORM, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.MIN_VALUE && !this.inConstantVariable(FLOAT_SIG, MIN_VAL)) {
                return new FieldExprent(MIN_VAL, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == -3.4028235E38f && !this.inConstantVariable(FLOAT_SIG, MAX_VAL)) {
                return new FieldExprent(MAX_VAL, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
            }
            if (floatVal == -1.1754944E-38f && !this.inConstantVariable(FLOAT_SIG, MIN_NORM)) {
                return new FieldExprent(MIN_NORM, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
            }
            if (floatVal == -1.4E-45f && !this.inConstantVariable(FLOAT_SIG, MIN_VAL)) {
                return new FieldExprent(MIN_VAL, FLOAT_SIG, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
            }
            if (floatVal == (float)Math.E && !this.inConstantVariable(MATH_SIG, E)) {
                return new FieldExprent(E, MATH_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("(float)");
            }
            if (PI_FLOATS.containsKey(Float.valueOf(floatVal)) && !this.inConstantVariable(MATH_SIG, PI)) {
                String[] parts = PI_FLOATS.get(Float.valueOf(floatVal));
                return this.getPiFloat(tracer).enclose(parts[0], parts[1]);
            }
            if (FLOAT_CONSTANTS.containsKey(Float.valueOf(floatVal))) {
                return new TextBuffer(FLOAT_CONSTANTS.get(Float.valueOf(floatVal)));
            }
        } else {
            if (Float.isNaN(floatVal)) {
                return new TextBuffer("0.0F / 0.0F");
            }
            if (floatVal == Float.POSITIVE_INFINITY) {
                return new TextBuffer("1.0F / 0.0F");
            }
            if (floatVal == Float.NEGATIVE_INFINITY) {
                return new TextBuffer("-1.0F / 0.0F");
            }
        }
        return new TextBuffer(ConstExprent.trimFloat(Float.toString(floatVal), floatVal)).append('F');
    }

    private TextBuffer getPiDouble(BytecodeMappingTracer tracer) {
        return new FieldExprent(PI, MATH_SIG, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
    }

    private TextBuffer getPiFloat(BytecodeMappingTracer tracer) {
        return this.getPiDouble(tracer).prepend("(float)");
    }

    @VisibleForTesting
    public static String trimFloat(String value, float start) {
        if (((String)value).length() <= 3 || !DecompilerContext.getOption("sfn")) {
            return value;
        }
        String exp = "";
        int eIdx = ((String)value).indexOf(69);
        if (eIdx != -1) {
            exp = ((String)value).substring(eIdx);
            value = ((String)value).substring(0, eIdx);
        }
        String temp = value;
        int dotIdx = ((String)value).indexOf(46);
        while (!(temp = ((String)(value = temp)).substring(0, ((String)value).length() - 1)).isEmpty() && !"-".equals(temp) && Float.parseFloat(temp + exp) == start) {
        }
        if (dotIdx != -1 && ((String)value).indexOf(46) == -1) {
            value = (String)value + ".0";
        } else if (dotIdx != -1) {
            String integer = ((String)value).substring(0, dotIdx);
            String decimal = ((String)value).substring(dotIdx + 1);
            String rounded = Integer.parseInt(integer) + 1 + ".0" + exp;
            if (Float.parseFloat(rounded) == start) {
                return rounded;
            }
            long decimalVal = 1L;
            int leadingZeros = 0;
            for (int i = 0; i < decimal.length() - 1; ++i) {
                if (decimal.charAt(i) == '0' && leadingZeros == i) {
                    ++leadingZeros;
                }
                decimalVal = (decimalVal - 1L) * 10L + (long)decimal.charAt(i) - 48L + 1L;
                rounded = integer + "." + "0".repeat(leadingZeros) + decimalVal + exp;
                if (Float.parseFloat(rounded) != start) continue;
                return rounded;
            }
        }
        return (String)value + exp;
    }

    @VisibleForTesting
    public static String trimDouble(String value, double start) {
        if (((String)value).length() <= 3 || !DecompilerContext.getOption("sfn")) {
            return value;
        }
        String exp = "";
        int eIdx = ((String)value).indexOf(69);
        if (eIdx != -1) {
            exp = ((String)value).substring(eIdx);
            value = ((String)value).substring(0, eIdx);
        }
        String temp = value;
        int dotIdx = ((String)value).indexOf(46);
        while (!(temp = ((String)(value = temp)).substring(0, ((String)value).length() - 1)).isEmpty() && !"-".equals(temp) && Double.parseDouble(temp + exp) == start) {
        }
        if (dotIdx != -1 && ((String)value).indexOf(46) == -1) {
            value = (String)value + ".0";
        } else if (dotIdx != -1) {
            String integer = ((String)value).substring(0, dotIdx);
            String decimal = ((String)value).substring(dotIdx + 1);
            String rounded = Long.parseLong(integer) + 1L + ".0" + exp;
            if (Double.parseDouble(rounded) == start) {
                return rounded;
            }
            long decimalVal = 1L;
            int leadingZeros = 0;
            for (int i = 0; i < decimal.length() - 1; ++i) {
                if (decimal.charAt(i) == '0' && leadingZeros == i) {
                    ++leadingZeros;
                }
                decimalVal = (decimalVal - 1L) * 10L + (long)decimal.charAt(i) - 48L + 1L;
                rounded = integer + "." + "0".repeat(leadingZeros) + decimalVal + exp;
                if (Double.parseDouble(rounded) != start) continue;
                return rounded;
            }
        }
        return (String)value + exp;
    }

    private boolean inConstantVariable(String classSignature, String variableName) {
        ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        return node.classStruct.qualifiedName.equals(classSignature) && this.parent instanceof StructField && ((StructField)this.parent).getName().equals(variableName);
    }

    public boolean isNull() {
        return 13 == this.constType.getType();
    }

    private static String convertStringToJava(String value, boolean ascii) {
        char[] arr = value.toCharArray();
        StringBuilder buffer = new StringBuilder(arr.length);
        block9: for (char c : arr) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                default: {
                    if (ConstExprent.isPrintableAscii(c) || !ascii && TextUtil.isPrintableUnicode(c)) {
                        buffer.append(c);
                        continue block9;
                    }
                    buffer.append(TextUtil.charToUnicodeLiteral(c));
                }
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstExprent)) {
            return false;
        }
        ConstExprent cn = (ConstExprent)o;
        return Objects.equals(this.constType, cn.getConstType()) && Objects.equals(this.value, cn.getValue());
    }

    public int hashCode() {
        int result = this.constType.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean hasBooleanValue() {
        switch (this.constType.getType()) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                int value = (Integer)this.value;
                return value == 0 || DecompilerContext.getOption("bto") && value == 1;
            }
        }
        return false;
    }

    public boolean hasValueOne() {
        return switch (this.constType.getType()) {
            case 0, 1, 4, 6, 7, 15, 16 -> {
                if ((Integer)this.value == 1) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (((Long)this.value).intValue() == 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((Double)this.value).intValue() == 1) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (((Float)this.value).intValue() == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static ConstExprent getZeroConstant(int type) {
        return switch (type) {
            case 4 -> new ConstExprent(VarType.VARTYPE_INT, 0, null);
            case 5 -> new ConstExprent(VarType.VARTYPE_LONG, 0L, null);
            case 2 -> new ConstExprent(VarType.VARTYPE_DOUBLE, 0.0, null);
            case 3 -> new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(0.0f), null);
            default -> throw new RuntimeException("Invalid argument: " + type);
        };
    }

    @NotNull
    public VarType getConstType() {
        VarType varType = this.constType;
        if (varType == null) {
            ConstExprent.$$$reportNull$$$0(1);
        }
        return varType;
    }

    public void setConstType(@Nullable VarType constType) {
        if (constType == null) {
            constType = VarType.VARTYPE_UNKNOWN;
        }
        this.constType = constType;
    }

    public void adjustConstType(VarType expectedType) {
        if ((expectedType.equals(VarType.VARTYPE_CHAR) || expectedType.equals(VarType.VARTYPE_CHARACTER)) && (this.constType.equals(VarType.VARTYPE_BYTECHAR) || this.constType.equals(VarType.VARTYPE_SHORTCHAR))) {
            int intValue = this.getIntValue();
            if (ConstExprent.isPrintableAscii(intValue) || CHAR_ESCAPES.containsKey(intValue)) {
                this.setConstType(VarType.VARTYPE_CHAR);
            }
        } else if ((expectedType.equals(VarType.VARTYPE_INT) || expectedType.equals(VarType.VARTYPE_INTEGER)) && this.constType.getTypeFamily() == 2) {
            this.setConstType(VarType.VARTYPE_INT);
        }
    }

    private static boolean isPrintableAscii(int c) {
        return c >= 32 && c < 127;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean isBoolPermitted() {
        return this.boolPermitted;
    }

    @Override
    public void fillBytecodeRange(@Nullable BitSet values) {
        this.measureBytecode(values);
    }

    @Override
    public String toString() {
        return "const(" + String.valueOf(this.toJava(0, new BytecodeMappingTracer())) + ")";
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_CONSTTYPE ? !value.value.equals(this.constType) : key == IMatchable.MatchProperties.EXPRENT_CONSTVALUE && value.isVariable() && !engine.checkAndSetVariableValue(value.value.toString(), this.value))) continue;
            return false;
        }
        return true;
    }

    static {
        double PI_D = Math.PI;
        float PI_F = (float)Math.PI;
        PI_DOUBLES.put(Math.PI, new String[]{"", ""});
        PI_DOUBLES.put(-Math.PI, new String[]{"-", ""});
        PI_FLOATS.put(Float.valueOf((float)Math.PI), new String[]{"", ""});
        PI_FLOATS.put(Float.valueOf((float)(-Math.PI)), new String[]{"-", ""});
        PI_DOUBLES.put(Math.PI * 2, new String[]{"(", " * 2D)"});
        PI_DOUBLES.put(Math.PI * -2, new String[]{"(-", " * 2D)"});
        PI_FLOATS.put(Float.valueOf((float)Math.PI * 2), new String[]{"(", " * 2F)"});
        PI_FLOATS.put(Float.valueOf((float)Math.PI * -2), new String[]{"(-", " * 2F)"});
        PI_DOUBLES.put(1.5707963267948966, new String[]{"(", " / 2D)"});
        PI_DOUBLES.put(-1.5707963267948966, new String[]{"(-", " / 2D)"});
        PI_FLOATS.put(Float.valueOf(1.5707964f), new String[]{"(", " / 2F)"});
        PI_FLOATS.put(Float.valueOf(-1.5707964f), new String[]{"(-", " / 2F)"});
        PI_DOUBLES.put(4.71238898038469, new String[]{"(", " * 1.5D)"});
        PI_DOUBLES.put(-4.71238898038469, new String[]{"(-", " * 1.5D)"});
        PI_FLOATS.put(Float.valueOf(4.712389f), new String[]{"(", " * 1.5F)"});
        PI_FLOATS.put(Float.valueOf(-4.712389f), new String[]{"(-", " * 1.5F)"});
        PI_DOUBLES.put(1.0471975511965976, new String[]{"(", " / 3D)"});
        PI_DOUBLES.put(-1.0471975511965976, new String[]{"(-", " / 3D)"});
        PI_FLOATS.put(Float.valueOf(1.0471976f), new String[]{"(", " / 3F)"});
        PI_FLOATS.put(Float.valueOf(-1.0471976f), new String[]{"(-", " / 3F)"});
        PI_DOUBLES.put(0.7853981633974483, new String[]{"(", " / 4D)"});
        PI_DOUBLES.put(-0.7853981633974483, new String[]{"(-", " / 4D)"});
        PI_FLOATS.put(Float.valueOf(0.7853982f), new String[]{"(", " / 4F)"});
        PI_FLOATS.put(Float.valueOf(-0.7853982f), new String[]{"(-", " / 4F)"});
        PI_DOUBLES.put(0.6283185307179586, new String[]{"(", " / 5D)"});
        PI_DOUBLES.put(-0.6283185307179586, new String[]{"(-", " / 5D)"});
        PI_FLOATS.put(Float.valueOf(0.62831855f), new String[]{"(", " / 5F)"});
        PI_FLOATS.put(Float.valueOf(-0.62831855f), new String[]{"(-", " / 5F)"});
        PI_DOUBLES.put(0.5235987755982988, new String[]{"(", " / 6D)"});
        PI_DOUBLES.put(-0.5235987755982988, new String[]{"(-", " / 6D)"});
        PI_FLOATS.put(Float.valueOf(0.5235988f), new String[]{"(", " / 6F)"});
        PI_FLOATS.put(Float.valueOf(-0.5235988f), new String[]{"(-", " / 6F)"});
        PI_DOUBLES.put(0.39269908169872414, new String[]{"(", " / 8D)"});
        PI_DOUBLES.put(-0.39269908169872414, new String[]{"(-", " / 8D)"});
        PI_FLOATS.put(Float.valueOf(0.3926991f), new String[]{"(", " / 8F)"});
        PI_FLOATS.put(Float.valueOf(-0.3926991f), new String[]{"(-", " / 8F)"});
        PI_DOUBLES.put(0.3141592653589793, new String[]{"(", " / 10D)"});
        PI_DOUBLES.put(-0.3141592653589793, new String[]{"(-", " / 10D)"});
        PI_FLOATS.put(Float.valueOf(0.31415927f), new String[]{"(", " / 10F)"});
        PI_FLOATS.put(Float.valueOf(-0.31415927f), new String[]{"(-", " / 10F)"});
        PI_DOUBLES.put(Math.PI / 180, new String[]{"(", " / 180D)"});
        PI_DOUBLES.put(57.29577951308232, new String[]{"(180D / ", ")"});
        PI_FLOATS.put(Float.valueOf((float)Math.PI / 180), new String[]{"(", " / 180F)"});
        PI_FLOATS.put(Float.valueOf(57.295776f), new String[]{"(180F / ", ")"});
        FLOAT_CONSTANTS.put(Float.valueOf(2.1474836E9f), "(float)Integer.MAX_VALUE");
        FLOAT_CONSTANTS.put(Float.valueOf(-2.1474836E9f), "(float)Integer.MIN_VALUE");
        FLOAT_CONSTANTS.put(Float.valueOf(9.223372E18f), "(float)Long.MAX_VALUE");
        FLOAT_CONSTANTS.put(Float.valueOf(-9.223372E18f), "(float)Long.MIN_VALUE");
        DOUBLE_CONSTANTS.put(2.147483647E9, "(double)Integer.MAX_VALUE");
        DOUBLE_CONSTANTS.put(-2.147483648E9, "(double)Integer.MIN_VALUE");
        DOUBLE_CONSTANTS.put(9.223372036854776E18, "(double)Long.MAX_VALUE");
        DOUBLE_CONSTANTS.put(-9.223372036854776E18, "(double)Long.MIN_VALUE");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/java/decompiler/modules/decompiler/exps/ConstExprent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExprType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

