/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.mpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.mpp.ClassLikeSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualMatcher;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0005j\u0002`\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualResolver;", "", "<init>", "()V", "findExpectForActual", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility;", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/ExpectForActualMatchingData;", "actualSymbol", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "context", "Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualResolver.kt\norg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualResolver\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,103:1\n24#2:104\n48#2:122\n774#3:105\n865#3,2:106\n1491#3:108\n1516#3,3:109\n1519#3,3:119\n384#4,7:112\n*S KotlinDebug\n*F\n+ 1 FirExpectActualResolver.kt\norg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualResolver\n*L\n53#1:104\n90#1:122\n66#1:105\n66#1:106,2\n70#1:108\n70#1:109,3\n70#1:119,3\n70#1:112,7\n*E\n"})
public final class FirExpectActualResolver {
    @NotNull
    public static final FirExpectActualResolver INSTANCE = new FirExpectActualResolver();

    private FirExpectActualResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> findExpectForActual(@NotNull FirBasedSymbol<?> actualSymbol, @NotNull FirSession useSiteSession, @NotNull FirExpectActualMatchingContext context) {
        Object object;
        FirClassLikeSymbol<?> actualContainingClass;
        Intrinsics.checkNotNullParameter(actualSymbol, "actualSymbol");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(context, "context");
        FirExpectActualMatchingContext $this$findExpectForActual_u24lambda_u246 = context;
        boolean bl = false;
        FirBasedSymbol<?> firBasedSymbol = actualSymbol;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$filterTo$iv$iv;
            Collection collection;
            CallableId callableId = ((FirCallableSymbol)actualSymbol).getCallableId();
            ClassId classId = callableId.getClassId();
            actualContainingClass = null;
            FirRegularClassSymbol expectContainingClass = null;
            if (callableId.isLocal()) {
                return MapsKt.emptyMap();
            }
            if (classId != null) {
                Collection collection2;
                List<FirBasedSymbol<?>> list;
                Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> map;
                FirRegularClass firRegularClass;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(useSiteSession).getClassLikeSymbolByClassId(classId);
                actualContainingClass = firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, useSiteSession) : null;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = actualContainingClass;
                firClassLikeSymbol = firClassLikeSymbol2 != null && (firRegularClass = (FirRegularClass)firClassLikeSymbol2.getFir()) != null && (map = ExpectActualAttributesKt.getExpectForActual(firRegularClass)) != null && (list = map.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE)) != null ? CollectionsKt.singleOrNull(list) : null;
                expectContainingClass = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if (actualSymbol instanceof FirConstructorSymbol) {
                    FirRegularClassSymbol firRegularClassSymbol = expectContainingClass;
                    collection2 = firRegularClassSymbol != null ? FirExpectActualMatchingContext.getConstructors$default($this$findExpectForActual_u24lambda_u246, firRegularClassSymbol, $this$findExpectForActual_u24lambda_u246.getExpectScopeSession(), null, 2, null) : null;
                } else {
                    FirCallableSymbol $this$isStatic$iv = (FirCallableSymbol)actualSymbol;
                    boolean $i$f$isStatic = false;
                    if ($this$isStatic$iv.getRawStatus().isStatic()) {
                        FirRegularClassSymbol firRegularClassSymbol = expectContainingClass;
                        collection2 = firRegularClassSymbol != null ? $this$findExpectForActual_u24lambda_u246.getStaticCallablesForExpectClass(firRegularClassSymbol, ((FirCallableSymbol)actualSymbol).getName()) : null;
                    } else {
                        FirRegularClassSymbol firRegularClassSymbol = expectContainingClass;
                        collection2 = collection = (Collection)(firRegularClassSymbol != null ? $this$findExpectForActual_u24lambda_u246.getCallablesForExpectClass(firRegularClassSymbol, ((FirCallableSymbol)actualSymbol).getName()) : null);
                    }
                }
                if (collection2 == null) {
                    collection = CollectionsKt.emptyList();
                }
            } else {
                List $i$f$isStatic;
                FirPackageMemberScope scope2 = new FirPackageMemberScope(callableId.getPackageName(), useSiteSession, FirSymbolProviderKt.getDependenciesSymbolProvider(useSiteSession), null, 8, null);
                List $this$findExpectForActual_u24lambda_u246_u24lambda_u242 = $i$f$isStatic = (List)new ArrayList();
                boolean bl2 = false;
                scope2.processFunctionsByName(callableId.getCallableName(), arg_0 -> FirExpectActualResolver.findExpectForActual$lambda$6$lambda$2$lambda$0($this$findExpectForActual_u24lambda_u246_u24lambda_u242, arg_0));
                scope2.processPropertiesByName(callableId.getCallableName(), arg_0 -> FirExpectActualResolver.findExpectForActual$lambda$6$lambda$2$lambda$1($this$findExpectForActual_u24lambda_u246_u24lambda_u242, arg_0));
                collection = $i$f$isStatic;
            }
            Collection candidates = collection;
            List<FirModuleData> transitiveDependsOn = ((FirCallableSymbol)actualSymbol).getModuleData().getAllDependsOnDependencies();
            Iterable $this$filter$iv = candidates;
            boolean $i$f$filter = false;
            Iterable bl2 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirCallableSymbol expectSymbol = (FirCallableSymbol)element$iv$iv;
                boolean bl3 = false;
                if (!(!Intrinsics.areEqual(actualSymbol, expectSymbol) && (expectContainingClass != null && !Intrinsics.areEqual($this$findExpectForActual_u24lambda_u246.getVisibility(expectSymbol), Visibilities.Private.INSTANCE) || $this$findExpectForActual_u24lambda_u246.isExpect(expectSymbol) && transitiveDependsOn.contains(expectSymbol.getModuleData())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                FirCallableSymbol expectDeclaration = (FirCallableSymbol)element$iv$iv;
                boolean bl4 = false;
                ExpectActualMatchingCompatibility key$iv$iv = AbstractExpectActualMatcher.INSTANCE.getCallablesMatchingCompatibility(expectDeclaration, (CallableSymbolMarker)((Object)actualSymbol), expectContainingClass, (RegularClassSymbolMarker)((Object)actualContainingClass), context);
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Object it = destination$iv$iv;
            boolean bl6 = false;
            List compatibleSymbols = (List)it.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
            object = compatibleSymbols == null ? it : MapsKt.mapOf(TuplesKt.to(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE, compatibleSymbols));
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            actualContainingClass = FirSymbolProviderKt.getDependenciesSymbolProvider(useSiteSession).getClassLikeSymbolByClassId(((FirClassLikeSymbol)actualSymbol).getClassId());
            FirRegularClassSymbol firRegularClassSymbol = actualContainingClass instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)actualContainingClass : null;
            if (firRegularClassSymbol == null) {
                return MapsKt.emptyMap();
            }
            FirRegularClassSymbol expectClassSymbol = firRegularClassSymbol;
            List<FirModuleData> transitiveDependsOn = ((FirClassLikeSymbol)actualSymbol).getModuleData().getAllDependsOnDependencies();
            FirClassLikeSymbol $this$isExpect$iv = expectClassSymbol;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getRawStatus().isExpect() && transitiveDependsOn.contains(expectClassSymbol.getModuleData())) {
                ExpectActualMatchingCompatibility compatibility = AbstractExpectActualMatcher.INSTANCE.matchClassifiers(expectClassSymbol, (ClassLikeSymbolMarker)((Object)actualSymbol), context);
                object = MapsKt.mapOf(TuplesKt.to(compatibility, CollectionsKt.listOf(expectClassSymbol)));
            } else {
                object = MapsKt.emptyMap();
            }
        } else {
            object = MapsKt.emptyMap();
        }
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> result2 = object;
        return result2;
    }

    private static final Unit findExpectForActual$lambda$6$lambda$2$lambda$0(List $this_apply, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $this_apply.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit findExpectForActual$lambda$6$lambda$2$lambda$1(List $this_apply, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $this_apply.add(it);
        return Unit.INSTANCE;
    }
}

