/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/CreateNewIgnoreFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "ignoreFileName", "", "ignoreFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmCreateIgnoreFile", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class CreateNewIgnoreFileAction
extends DumbAwareAction {
    @NotNull
    private final String ignoreFileName;
    @NotNull
    private final VirtualFile ignoreFileRoot;

    public CreateNewIgnoreFileAction(@NotNull String ignoreFileName, @NotNull VirtualFile ignoreFileRoot) {
        Intrinsics.checkNotNullParameter((Object)ignoreFileName, (String)"ignoreFileName");
        Intrinsics.checkNotNullParameter((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        this.ignoreFileName = ignoreFileName;
        this.ignoreFileRoot = ignoreFileRoot;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project2, (VirtualFile)this.ignoreFileRoot);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs ignoreFileRootVcs = abstractVcs;
        List<IgnoredFileBean> ignored = IgnoreFileActionKt.getIgnoredFileBeans(e, this.ignoreFileRoot, ignoreFileRootVcs);
        if (ignored.isEmpty() || !this.confirmCreateIgnoreFile(project2)) {
            return;
        }
        Object object = ActionsKt.runUndoTransparentWriteAction(() -> CreateNewIgnoreFileAction.actionPerformed$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runUndoTransparentWriteAction(...)");
        VirtualFile ignoreFile = (VirtualFile)object;
        IgnoreFileActionKt.writeIgnoreFileEntries$default(project2, ignoreFile, ignored, null, null, 24, null);
    }

    private final boolean confirmCreateIgnoreFile(Project project) {
        Object[] objectArray = new Object[]{this.ignoreFileName, FileUtil.getLocationRelativeToUserHome((String)this.ignoreFileRoot.getPresentableUrl())};
        String string = VcsBundle.message((String)"vcs.add.to.ignore.file.create.ignore.file.confirmation.message", (Object[])objectArray);
        objectArray = new Object[]{this.ignoreFileName};
        String string2 = VcsBundle.message((String)"vcs.add.to.ignore.file.create.ignore.file.confirmation.title", (Object[])objectArray);
        objectArray = new String[]{IdeBundle.message((String)"button.create", (Object[])new Object[0]), CommonBundle.getCancelButtonText()};
        return Messages.showDialog((Project)project, (String)string, (String)string2, null, (String[])objectArray, (int)0, (int)1, (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static final VirtualFile actionPerformed$lambda$0(CreateNewIgnoreFileAction this$0) {
        return this$0.ignoreFileRoot.createChildData((Object)this$0.ignoreFileRoot, this$0.ignoreFileName);
    }
}

