/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class CachingNotationConverter<T>
implements NotationConverter<Object, T> {
    private final InMemoryLoadingCache<Object, T> cache;
    private final NotationConverterToNotationParserAdapter<Object, T> delegate;

    public CachingNotationConverter(NotationConverter<Object, T> notationConverter, InMemoryCacheFactory cacheFactory) {
        this.delegate = new NotationConverterToNotationParserAdapter(notationConverter);
        this.cache = cacheFactory.create(arg_0 -> this.delegate.parseNotation(arg_0));
    }

    public void convert(Object notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        result.converted(this.cache.get(notation));
    }

    public void describe(DiagnosticsVisitor visitor) {
        this.delegate.describe(visitor);
    }
}

