# GNU Radio ModTool completion for fish                    -*- shell-script -*-
#
# Copyright 2014 Pallets
# Copyright 2024 Oleg Nikitin
#
# This file is part of GNU Radio
#
# SPDX-License-Identifier: GPL-3.0-or-later
#

function _gr_modtool_completion
    set -l response (env _GR_MODTOOL_COMPLETE=fish_complete COMP_WORDS=(commandline -cp) COMP_CWORD=(commandline -t) gr_modtool)

    for completion in $response
        set -l metadata (string split "," $completion)

        if test $metadata[1] = "dir"
            __fish_complete_directories $metadata[2]
        else if test $metadata[1] = "file"
            __fish_complete_path $metadata[2]
        else if test $metadata[1] = "plain"
            echo $metadata[2]
        end
    end
end

complete --no-files --command gr_modtool --arguments "(_gr_modtool_completion)"
