/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Obstacle;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.Segment;
import org.eclipse.draw2d.graph.Vertex;

public class ShortestPathRouter {
    private static final int NUM_GROW_PASSES = 2;
    private int spacing = 4;
    private boolean growPassChangedObstacles;
    private List<Path> orderedPaths;
    private final Map<Path, List<Path>> pathsToChildPaths;
    private PathStack stack;
    private List<Path> subPaths;
    private final List<Obstacle> userObstacles;
    private final List<Path> userPaths = new ArrayList<Path>();
    private final List<Path> workingPaths = new ArrayList<Path>();

    public ShortestPathRouter() {
        this.pathsToChildPaths = new HashMap<Path, List<Path>>();
        this.userObstacles = new ArrayList<Obstacle>();
    }

    public boolean addObstacle(Rectangle rect) {
        return this.internalAddObstacle(new Obstacle(rect, this));
    }

    public void addPath(Path path) {
        this.userPaths.add(path);
        this.workingPaths.add(path);
    }

    private void bendPaths() {
        for (Path path : this.orderedPaths) {
            Segment segment = null;
            path.points.addPoint(new Point(path.start.x, path.start.y));
            int v = 0;
            while (v < path.grownSegments.size()) {
                segment = path.grownSegments.get(v);
                Vertex vertex = segment.end;
                if (vertex != null && v < path.grownSegments.size() - 1) {
                    if (vertex.type == 1) {
                        ++vertex.count;
                        path.points.addPoint(vertex.bend(vertex.count));
                    } else {
                        path.points.addPoint(vertex.bend(vertex.totalCount));
                        --vertex.totalCount;
                    }
                }
                ++v;
            }
            path.points.addPoint(new Point(path.end.x, path.end.y));
        }
    }

    private void checkVertexForIntersections(Vertex vertex) {
        if (vertex.nearestObstacle != 0 || vertex.nearestObstacleChecked) {
            return;
        }
        int sideLength = 2 * (vertex.totalCount * this.getSpacing()) + 1;
        int y = (vertex.positionOnObstacle & 1) > 0 ? vertex.y - sideLength : vertex.y;
        int x = (vertex.positionOnObstacle & 0x10) > 0 ? vertex.x : vertex.x - sideLength;
        Rectangle r = new Rectangle(x, y, sideLength, sideLength);
        for (Obstacle obs : this.userObstacles) {
            int yDist;
            int xDist;
            int pos;
            if (obs == vertex.obs || !r.intersects(obs) || (pos = obs.getPosition(vertex)) == 0 || Math.max(xDist = (pos & 0x10) > 0 ? vertex.x - obs.right() + 1 : obs.x - vertex.x, yDist = (pos & 1) > 0 ? obs.y - vertex.y : vertex.y - obs.bottom() + 1) >= vertex.nearestObstacle && vertex.nearestObstacle != 0) continue;
            vertex.nearestObstacle = Math.max(xDist, yDist);
            vertex.updateOffset();
        }
        vertex.nearestObstacleChecked = true;
    }

    private void checkVertexIntersections() {
        for (Path path : this.workingPaths) {
            int s = 0;
            while (s < path.segments.size() - 1) {
                Vertex vertex = path.segments.get((int)s).end;
                this.checkVertexForIntersections(vertex);
                ++s;
            }
        }
    }

    private void cleanup() {
        for (Path path : this.workingPaths) {
            path.cleanup();
        }
    }

    private void countVertices() {
        for (Path path : this.workingPaths) {
            int v = 0;
            while (v < path.segments.size() - 1) {
                ++path.segments.get((int)v).end.totalCount;
                ++v;
            }
        }
    }

    private static boolean dirtyPathsOn(Vertex vertex) {
        List<Path> paths = vertex.paths;
        if (paths != null && !paths.isEmpty()) {
            for (Path path : paths) {
                path.isDirty = true;
            }
            return true;
        }
        return false;
    }

    private static Vertex getNearestVertex(Vertex v1, Vertex v2, Segment segment) {
        if (segment.start.getDistance(v1) + segment.end.getDistance(v1) > segment.start.getDistance(v2) + segment.end.getDistance(v2)) {
            return v2;
        }
        return v1;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private Path getSubpathForSplit(Path path, Segment segment) {
        Path newPath = path.getSubPath(segment);
        this.workingPaths.add(newPath);
        this.subPaths.add(newPath);
        return newPath;
    }

    private void growObstacles() {
        this.growPassChangedObstacles = false;
        int i = 0;
        while (i < 2) {
            if (i == 0 || this.growPassChangedObstacles) {
                this.growObstaclesPass();
            }
            ++i;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void growObstaclesPass() {
        for (Obstacle userObstacle : this.userObstacles) {
            userObstacle.growVertices();
        }
        for (Path path : this.workingPaths) {
            for (Object element : path.excludedObstacles) {
                ((Obstacle)element).exclude = true;
            }
            if (path.grownSegments.isEmpty()) {
                for (Object element : path.segments) {
                    this.testOffsetSegmentForIntersections((Segment)element, -1, path);
                }
            } else {
                int counter = 0;
                ArrayList<Segment> currentSegments = new ArrayList<Segment>(path.grownSegments);
                int s = 0;
                while (s < currentSegments.size()) {
                    counter += this.testOffsetSegmentForIntersections((Segment)currentSegments.get(s), s + counter, path);
                    ++s;
                }
            }
            for (Obstacle element : path.excludedObstacles) {
                element.exclude = false;
            }
        }
        for (Obstacle userObstacle : this.userObstacles) {
            userObstacle.shrinkVertices();
        }
    }

    private boolean internalAddObstacle(Obstacle obs) {
        this.userObstacles.add(obs);
        return this.testAndDirtyPaths(obs);
    }

    private boolean internalRemoveObstacle(Rectangle rect) {
        Obstacle obs = null;
        int index = -1;
        int i = 0;
        while (i < this.userObstacles.size()) {
            obs = this.userObstacles.get(i);
            if (obs.equals(rect)) {
                index = i;
                break;
            }
            ++i;
        }
        this.userObstacles.remove(index);
        boolean result = false;
        result |= ShortestPathRouter.dirtyPathsOn(obs.bottomLeft);
        result |= ShortestPathRouter.dirtyPathsOn(obs.topLeft);
        result |= ShortestPathRouter.dirtyPathsOn(obs.bottomRight);
        result |= ShortestPathRouter.dirtyPathsOn(obs.topRight);
        for (Path path : this.workingPaths) {
            if (path.isDirty || !path.isObstacleVisible(obs)) continue;
            result = true;
            path.isDirty = true;
        }
        return result;
    }

    private void labelPath(Path path) {
        Segment segment = null;
        Segment nextSegment = null;
        Vertex vertex = null;
        boolean agree = false;
        int v = 0;
        while (v < path.grownSegments.size() - 1) {
            segment = path.grownSegments.get(v);
            nextSegment = path.grownSegments.get(v + 1);
            vertex = segment.end;
            long crossProduct = segment.crossProduct(new Segment(vertex, vertex.obs.center));
            if (vertex.type == 0) {
                ShortestPathRouter.labelVertex(segment, crossProduct, path);
            } else if (!path.isInverted && (crossProduct > 0L && vertex.type == 2 || crossProduct < 0L && vertex.type == 1)) {
                if (agree) {
                    this.stack.push(this.getSubpathForSplit(path, segment));
                    return;
                }
                path.isInverted = true;
                path.invertPriorVertices(segment);
            } else {
                if (path.isInverted && (crossProduct < 0L && vertex.type == 2 || crossProduct > 0L && vertex.type == 1)) {
                    this.stack.push(this.getSubpathForSplit(path, segment));
                    return;
                }
                agree = true;
            }
            if (vertex.paths != null) {
                for (Path nextPath : vertex.paths) {
                    if (nextPath.isMarked) continue;
                    nextPath.isMarked = true;
                    this.stack.push(nextPath);
                }
            }
            vertex.addPath(path, segment, nextSegment);
            ++v;
        }
    }

    private void labelPaths() {
        Path workingPath;
        Path path = null;
        Iterator<Path> iterator = this.workingPaths.iterator();
        while (iterator.hasNext()) {
            path = workingPath = iterator.next();
            this.stack.push(path);
        }
        while (!this.stack.isEmpty()) {
            path = this.stack.pop();
            if (path.isMarked) continue;
            path.isMarked = true;
            this.labelPath(path);
        }
        iterator = this.workingPaths.iterator();
        while (iterator.hasNext()) {
            path = workingPath = iterator.next();
            path.isMarked = false;
        }
    }

    private static void labelVertex(Segment segment, long crossProduct, Path path) {
        segment.end.type = crossProduct > 0L ? (path.isInverted ? 2 : 1) : (crossProduct < 0L ? (path.isInverted ? 1 : 2) : (segment.start.type != 0 ? segment.start.type : 1));
    }

    private void orderPath(Path path) {
        if (path.isMarked) {
            return;
        }
        path.isMarked = true;
        Segment segment = null;
        Vertex vertex = null;
        int v = 0;
        while (v < path.grownSegments.size() - 1) {
            segment = path.grownSegments.get(v);
            vertex = segment.end;
            double thisAngle = vertex.cachedCosines.get(path);
            if (path.isInverted) {
                thisAngle = -thisAngle;
            }
            for (Path vPath : vertex.paths) {
                if (vPath.isMarked) continue;
                double otherAngle = vertex.cachedCosines.get(vPath);
                if (vPath.isInverted) {
                    otherAngle = -otherAngle;
                }
                if (!(otherAngle < thisAngle)) continue;
                this.orderPath(vPath);
            }
            ++v;
        }
        this.orderedPaths.add(path);
    }

    private void orderPaths() {
        for (Path path : this.workingPaths) {
            this.orderPath(path);
        }
    }

    private void recombineChildrenPaths() {
        for (Map.Entry<Path, List<Path>> entry : this.pathsToChildPaths.entrySet()) {
            Path path = entry.getKey();
            path.fullReset();
            Path childPath = null;
            Iterator<Path> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                Path childPath2;
                childPath = childPath2 = iterator.next();
                path.points.addAll(childPath.getPoints());
                path.points.removePoint(path.points.size() - 1);
                path.segments.addAll(childPath.segments);
                path.visibleObstacles.addAll(childPath.visibleObstacles);
            }
            path.points.addPoint(childPath.points.getLastPoint());
        }
    }

    private void recombineSubpaths() {
        for (Path path : this.orderedPaths) {
            path.reconnectSubPaths();
        }
        this.orderedPaths.removeAll(this.subPaths);
        this.workingPaths.removeAll(this.subPaths);
        this.subPaths = null;
    }

    public boolean removeObstacle(Rectangle rect) {
        return this.internalRemoveObstacle(rect);
    }

    public boolean removePath(Path path) {
        this.userPaths.remove(path);
        List<Path> children = this.pathsToChildPaths.get(path);
        if (children == null) {
            this.workingPaths.remove(path);
        } else {
            this.workingPaths.removeAll(children);
        }
        return true;
    }

    private void resetObstacleExclusions() {
        for (Obstacle userObstacle : this.userObstacles) {
            userObstacle.exclude = false;
        }
    }

    private void resetVertices() {
        Iterator<Object> iterator = this.userObstacles.iterator();
        while (iterator.hasNext()) {
            Obstacle userObstacle;
            Obstacle obs = userObstacle = iterator.next();
            obs.reset();
        }
        for (Path path : this.workingPaths) {
            path.start.fullReset();
            path.end.fullReset();
        }
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public List<Path> solve() {
        this.solveDirtyPaths();
        this.countVertices();
        this.checkVertexIntersections();
        this.growObstacles();
        this.subPaths = new ArrayList<Path>();
        this.stack = new PathStack();
        this.labelPaths();
        this.stack = null;
        this.orderedPaths = new ArrayList<Path>();
        this.orderPaths();
        this.bendPaths();
        this.recombineSubpaths();
        this.orderedPaths = null;
        this.subPaths = null;
        this.recombineChildrenPaths();
        this.cleanup();
        return Collections.unmodifiableList(this.userPaths);
    }

    private int solveDirtyPaths() {
        int numSolved = 0;
        for (Path path : this.userPaths) {
            if (!path.isDirty) continue;
            List<Path> children = this.pathsToChildPaths.get(path);
            int prevCount = 1;
            int newCount = 1;
            if (children == null) {
                children = Collections.emptyList();
            } else {
                prevCount = children.size();
            }
            if (path.getBendPoints() != null) {
                newCount = path.getBendPoints().size() + 1;
            }
            if (prevCount != newCount) {
                children = this.regenerateChildPaths(path, children, prevCount, newCount);
            }
            ShortestPathRouter.refreshChildrenEndpoints(path, children);
        }
        for (Path path : this.workingPaths) {
            path.refreshExcludedObstacles(this.userObstacles);
            if (!path.isDirty) {
                path.resetPartial();
                continue;
            }
            ++numSolved;
            path.fullReset();
            boolean pathFoundCheck = path.generateShortestPath(this.userObstacles);
            if (!pathFoundCheck || path.end.cost > path.threshold) {
                this.resetVertices();
                path.fullReset();
                path.threshold = 0.0;
                pathFoundCheck = path.generateShortestPath(this.userObstacles);
            }
            this.resetVertices();
        }
        this.resetObstacleExclusions();
        if (numSolved == 0) {
            this.resetVertices();
        }
        return numSolved;
    }

    private static void refreshChildrenEndpoints(Path path, List<Path> children) {
        Point previous = path.getStartPoint();
        PointList bendpoints = path.getBendPoints();
        int i = 0;
        while (i < children.size()) {
            Point next = i < bendpoints.size() ? bendpoints.getPoint(i) : path.getEndPoint();
            Path child = children.get(i);
            child.setStartPoint(previous);
            child.setEndPoint(next);
            previous = next;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<Path> regenerateChildPaths(Path path, List<Path> children, int currentSize, int newSize) {
        block2: {
            if (currentSize != 1) break block2;
            this.workingPaths.remove(path);
            currentSize = 0;
            children = new ArrayList<Path>(newSize);
            this.pathsToChildPaths.put(path, children);
            ** GOTO lbl24
        }
        if (newSize != 1) ** GOTO lbl24
        this.workingPaths.removeAll(children);
        this.workingPaths.add(path);
        this.pathsToChildPaths.remove(path);
        return Collections.emptyList();
lbl-1000:
        // 1 sources

        {
            child = new Path();
            this.workingPaths.add(child);
            children.add(child);
            ++currentSize;
lbl24:
            // 3 sources

            ** while (currentSize < newSize)
        }
lbl25:
        // 2 sources

        while (currentSize > newSize) {
            child = children.remove(children.size() - 1);
            this.workingPaths.remove(child);
            --currentSize;
        }
        return children;
    }

    private int testOffsetSegmentForIntersections(Segment segment, int index, Path path) {
        for (Obstacle obs : this.userObstacles) {
            Rectangle startRect;
            Rectangle endRect;
            if (segment.end.obs == obs || segment.start.obs == obs || obs.exclude) continue;
            Vertex vertex = null;
            int offset = this.getSpacing();
            if (segment.getSlope() < 0.0) {
                if (segment.intersects(obs.topLeft.x - offset, obs.topLeft.y - offset, obs.bottomRight.x + offset, obs.bottomRight.y + offset)) {
                    vertex = ShortestPathRouter.getNearestVertex(obs.topLeft, obs.bottomRight, segment);
                } else if (segment.intersects(obs.bottomLeft.x - offset, obs.bottomLeft.y + offset, obs.topRight.x + offset, obs.topRight.y - offset)) {
                    vertex = ShortestPathRouter.getNearestVertex(obs.bottomLeft, obs.topRight, segment);
                }
            } else if (segment.intersects(obs.bottomLeft.x - offset, obs.bottomLeft.y + offset, obs.topRight.x + offset, obs.topRight.y - offset)) {
                vertex = ShortestPathRouter.getNearestVertex(obs.bottomLeft, obs.topRight, segment);
            } else if (segment.intersects(obs.topLeft.x - offset, obs.topLeft.y - offset, obs.bottomRight.x + offset, obs.bottomRight.y + offset)) {
                vertex = ShortestPathRouter.getNearestVertex(obs.topLeft, obs.bottomRight, segment);
            }
            if (vertex == null) continue;
            Rectangle vRect = vertex.getDeformedRectangle(offset);
            if (segment.end.obs != null && vRect.intersects(endRect = segment.end.getDeformedRectangle(offset)) || segment.start.obs != null && vRect.intersects(startRect = segment.start.getDeformedRectangle(offset))) continue;
            Segment newSegmentStart = new Segment(segment.start, vertex);
            Segment newSegmentEnd = new Segment(vertex, segment.end);
            ++vertex.totalCount;
            vertex.nearestObstacleChecked = false;
            vertex.shrink();
            this.checkVertexForIntersections(vertex);
            vertex.grow();
            if (vertex.nearestObstacle != 0) {
                vertex.updateOffset();
            }
            this.growPassChangedObstacles = true;
            if (index != -1) {
                path.grownSegments.remove(segment);
                path.grownSegments.add(index, newSegmentStart);
                path.grownSegments.add(index + 1, newSegmentEnd);
            } else {
                path.grownSegments.add(newSegmentStart);
                path.grownSegments.add(newSegmentEnd);
            }
            return 1;
        }
        if (index == -1) {
            path.grownSegments.add(segment);
        }
        return 0;
    }

    private boolean testAndDirtyPaths(Obstacle obs) {
        boolean result = false;
        for (Path path : this.workingPaths) {
            result |= path.testAndSet(obs);
        }
        return result;
    }

    public boolean updateObstacle(Rectangle oldBounds, Rectangle newBounds) {
        boolean result = this.internalRemoveObstacle(oldBounds);
        return result |= this.addObstacle(newBounds);
    }

    static class PathStack
    extends ArrayList<Path> {
        PathStack() {
        }

        Path pop() {
            return (Path)this.remove(this.size() - 1);
        }

        void push(Path path) {
            this.add(path);
        }
    }
}

