﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/TrafficMirrorFilterRule.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DescribeTrafficMirrorFilterRulesResponse {
 public:
  AWS_EC2_API DescribeTrafficMirrorFilterRulesResponse() = default;
  AWS_EC2_API DescribeTrafficMirrorFilterRulesResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DescribeTrafficMirrorFilterRulesResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Traffic mirror rules.</p>
   */
  inline const Aws::Vector<TrafficMirrorFilterRule>& GetTrafficMirrorFilterRules() const { return m_trafficMirrorFilterRules; }
  template <typename TrafficMirrorFilterRulesT = Aws::Vector<TrafficMirrorFilterRule>>
  void SetTrafficMirrorFilterRules(TrafficMirrorFilterRulesT&& value) {
    m_trafficMirrorFilterRulesHasBeenSet = true;
    m_trafficMirrorFilterRules = std::forward<TrafficMirrorFilterRulesT>(value);
  }
  template <typename TrafficMirrorFilterRulesT = Aws::Vector<TrafficMirrorFilterRule>>
  DescribeTrafficMirrorFilterRulesResponse& WithTrafficMirrorFilterRules(TrafficMirrorFilterRulesT&& value) {
    SetTrafficMirrorFilterRules(std::forward<TrafficMirrorFilterRulesT>(value));
    return *this;
  }
  template <typename TrafficMirrorFilterRulesT = TrafficMirrorFilterRule>
  DescribeTrafficMirrorFilterRulesResponse& AddTrafficMirrorFilterRules(TrafficMirrorFilterRulesT&& value) {
    m_trafficMirrorFilterRulesHasBeenSet = true;
    m_trafficMirrorFilterRules.emplace_back(std::forward<TrafficMirrorFilterRulesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. The value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeTrafficMirrorFilterRulesResponse& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeTrafficMirrorFilterRulesResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TrafficMirrorFilterRule> m_trafficMirrorFilterRules;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_trafficMirrorFilterRulesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
