/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import java.io.Serializable;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.util.ClassUtil;

public abstract class TypeIdResolverBase
implements TypeIdResolver,
Serializable {
    private static final long serialVersionUID = 3L;
    protected final JavaType _baseType;

    protected TypeIdResolverBase() {
        this(null);
    }

    protected TypeIdResolverBase(JavaType baseType) {
        this._baseType = baseType;
    }

    @Override
    public void init(JavaType bt) {
    }

    @Override
    public String idFromBaseType(DatabindContext ctxt) {
        return this.idFromValueAndType(ctxt, null, this._baseType.getRawClass());
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) throws JacksonException {
        throw new IllegalStateException("Sub-class " + this.getClass().getName() + " MUST implement `typeFromId(DatabindContext,String)");
    }

    @Override
    public String getDescForKnownTypeIds() {
        return null;
    }

    protected Class<?> _resolveToParentAsNecessary(Class<?> cls) {
        if (ClassUtil.isEnumType(cls) && !cls.isEnum()) {
            cls = cls.getSuperclass();
        }
        return cls;
    }
}

