/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.slice;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.slice.PIntSlice;
import com.oracle.graal.python.builtins.objects.slice.PObjectSlice;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.slice.SliceBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSlice})
public final class SliceBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = SliceBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SliceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PSlice self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached GetClassNode getClassNode) {
            PTuple args = PFactory.createTuple(language, new Object[]{self.getStart(), self.getStop(), self.getStep()});
            return PFactory.createTuple(language, new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        @Specialization
        static long computeHash(VirtualFrame frame, PSlice self, @Bind Node inliningTarget, @Cached PyObjectHashNode hashNode) {
            int len = 3;
            long multiplier = 1000003L;
            long hash = 3430008L;
            long tmp = hashNode.execute((Frame)frame, inliningTarget, self.getStart());
            hash = (hash ^ tmp) * multiplier;
            tmp = hashNode.execute((Frame)frame, inliningTarget, self.getStop());
            hash = (hash ^ tmp) * (multiplier += (long)(82520 + len + len));
            tmp = hashNode.execute((Frame)frame, inliningTarget, self.getStep());
            hash = (hash ^ tmp) * (multiplier += (long)(82520 + len + len));
            if ((hash += 97531L) == -1L) {
                hash = -2L;
            }
            return hash;
        }
    }

    @Builtin(name="indices", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IndicesNode
    extends PythonBinaryBuiltinNode {
        IndicesNode() {
        }

        private static PTuple doPSlice(VirtualFrame frame, PSlice self, int length, SliceNodes.ComputeIndices compute, PythonLanguage language) {
            PSlice.SliceInfo sliceInfo = compute.execute((Frame)frame, self, length);
            return PFactory.createTuple(language, new Object[]{sliceInfo.start, sliceInfo.stop, sliceInfo.step});
        }

        protected static boolean isSafeIntSlice(PSlice self, Object length) {
            return self instanceof PIntSlice && length instanceof Integer;
        }

        @Specialization
        static PTuple safeInt(VirtualFrame frame, PIntSlice self, int length, @Bind PythonLanguage language, @Cached.Shared @Cached SliceNodes.ComputeIndices compute) {
            return IndicesNode.doPSlice(frame, self, length, compute, language);
        }

        @Specialization(guards={"!isPNone(length)"}, rewriteOn={PException.class})
        static PTuple doSliceObject(VirtualFrame frame, PSlice self, Object length, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached SliceNodes.SliceExactCastToInt toInt, @Cached.Shared @Cached SliceNodes.ComputeIndices compute) {
            return IndicesNode.doPSlice(frame, self, (Integer)toInt.execute((Frame)frame, inliningTarget, length), compute, language);
        }

        @Specialization(guards={"!isPNone(length)"}, replaces={"doSliceObject"})
        static PTuple doSliceObjectWithSlowPath(VirtualFrame frame, PSlice self, Object length, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached SliceNodes.SliceExactCastToInt toInt, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileError, @Cached SliceNodes.SliceCastToToBigInt castLengthNode, @Cached SliceNodes.CoerceToObjectSlice castNode) {
            try {
                return IndicesNode.doPSlice(frame, self, (Integer)toInt.execute((Frame)frame, inliningTarget, length), compute, language);
            }
            catch (PException pe) {
                if (!profileError.profileException(inliningTarget, pe, PythonBuiltinClassType.OverflowError)) {
                    throw pe;
                }
                Object lengthIn = castLengthNode.execute(inliningTarget, length);
                PObjectSlice.SliceObjectInfo sliceInfo = PObjectSlice.computeIndicesSlowPath(castNode.execute(self), lengthIn, true);
                return PFactory.createTuple(language, new Object[]{sliceInfo.start, sliceInfo.stop, sliceInfo.step});
            }
        }

        @Specialization(guards={"isPNone(length)"})
        static PTuple lengthNone(PSlice self, Object length, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError);
        }
    }

    @Builtin(name="step", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StepNode
    extends PythonUnaryBuiltinNode {
        StepNode() {
        }

        @Specialization
        protected static Object get(PIntSlice self) {
            return self.getStep();
        }

        @Specialization
        protected static Object get(PObjectSlice self) {
            return self.getStep();
        }
    }

    @Builtin(name="stop", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StopNode
    extends PythonUnaryBuiltinNode {
        StopNode() {
        }

        @Specialization
        protected static Object get(PIntSlice self) {
            return self.getStop();
        }

        @Specialization
        protected static Object get(PObjectSlice self) {
            return self.getStop();
        }
    }

    @Builtin(name="start", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StartNode
    extends PythonUnaryBuiltinNode {
        StartNode() {
        }

        @Specialization
        protected static Object get(PIntSlice self) {
            return self.getStart();
        }

        @Specialization
        protected static Object get(PObjectSlice self) {
            return self.getStart();
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        EqNode() {
        }

        @Specialization
        static boolean doIntSliceEq(PIntSlice left, PIntSlice right, RichCmpOp op, @Bind Node inliningTarget, @Cached @Cached.Exclusive InlinedConditionProfile startCmpProfile, @Cached @Cached.Exclusive InlinedConditionProfile stopCmpProfile, @Cached @Cached.Exclusive InlinedConditionProfile stepCmpProfile, @Cached PRaiseNode raiseNode) {
            if (startCmpProfile.profile(inliningTarget, left.start != right.start)) {
                return EqNode.cmpVal(inliningTarget, left.start, right.start, left.startIsNone, right.startIsNone, op, raiseNode);
            }
            if (stopCmpProfile.profile(inliningTarget, left.stop != right.stop)) {
                return EqNode.cmpVal(inliningTarget, left.stop, right.stop, false, false, op, raiseNode);
            }
            if (stepCmpProfile.profile(inliningTarget, left.step != right.step)) {
                return EqNode.cmpVal(inliningTarget, left.step, right.step, left.stepIsNone, right.stepIsNone, op, raiseNode);
            }
            return op.isEq() || op.isLe() || op.isGe();
        }

        private static boolean cmpVal(Node inliningTarget, int leftVal, int rightVal, boolean leftValIsNone, boolean rightValIsNone, RichCmpOp op, PRaiseNode raiseNode) {
            if (op.isEqOrNe()) {
                return op.isNe();
            }
            if (leftValIsNone || rightValIsNone) {
                Comparable<Object> leftObj = leftValIsNone ? PNone.NONE : Integer.valueOf(leftVal);
                Comparable<Object> rightObj = rightValIsNone ? PNone.NONE : Integer.valueOf(rightVal);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, op.getOpName(), leftObj, rightObj);
            }
            return op.compare(leftVal, rightVal);
        }

        static boolean noIntSlices(PSlice a, PSlice b) {
            return !(a instanceof PIntSlice) || !(b instanceof PIntSlice);
        }

        @Specialization(guards={"noIntSlices(left, right)", "left == right"})
        static boolean sliceCmpIdentical(VirtualFrame frame, PSlice left, PSlice right, RichCmpOp op) {
            return op.isEq() || op.isLe() || op.isGe();
        }

        @Specialization(guards={"noIntSlices(left, right)", "left != right"})
        static Object sliceCmpWithLib(VirtualFrame frame, PSlice left, PSlice right, RichCmpOp op, @Bind Node inliningTarget, @Cached @Cached.Exclusive InlinedConditionProfile startCmpProfile, @Cached @Cached.Exclusive InlinedConditionProfile stopCmpProfile, @Cached @Cached.Exclusive InlinedConditionProfile stepCmpProfile, @Cached PyObjectRichCompareBool eqNode, @Cached PyObjectRichCompare cmpNode) {
            if (startCmpProfile.profile(inliningTarget, !eqNode.executeEq((Frame)frame, inliningTarget, left.getStart(), right.getStart()))) {
                return cmpNode.execute(frame, inliningTarget, left.getStart(), right.getStart(), op);
            }
            if (stopCmpProfile.profile(inliningTarget, !eqNode.executeEq((Frame)frame, inliningTarget, left.getStop(), right.getStop()))) {
                return cmpNode.execute(frame, inliningTarget, left.getStop(), right.getStop(), op);
            }
            if (stepCmpProfile.profile(inliningTarget, !eqNode.executeEq((Frame)frame, inliningTarget, left.getStep(), right.getStep()))) {
                return cmpNode.execute(frame, inliningTarget, left.getStep(), right.getStep(), op);
            }
            return op.isEq() || op.isLe() || op.isGe();
        }

        @Fallback
        static Object doOthers(VirtualFrame frame, Object left, Object right, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static TruffleString repr(PSlice self) {
            return PythonUtils.toTruffleStringUncached(self.toString());
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="slice", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class SliceNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization(guards={"isNoValue(second)"})
        static Object singleArg(Object cls, Object first, Object second, Object third, @Bind Node inliningTarget, @Cached.Shared @Cached PySliceNew sliceNode) {
            return sliceNode.execute(inliningTarget, PNone.NONE, first, PNone.NONE);
        }

        @Specialization(guards={"!isNoValue(stop)", "isNoValue(step)"})
        static Object twoArgs(Object cls, Object start, Object stop, Object step, @Bind Node inliningTarget, @Cached.Shared @Cached PySliceNew sliceNode) {
            return sliceNode.execute(inliningTarget, start, stop, PNone.NONE);
        }

        @Fallback
        static Object threeArgs(Object cls, Object start, Object stop, Object step, @Bind Node inliningTarget, @Cached.Shared @Cached PySliceNew sliceNode) {
            return sliceNode.execute(inliningTarget, start, stop, step);
        }
    }
}

