/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tokenize;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.tokenize.PTokenizerIter;
import com.oracle.graal.python.builtins.objects.tokenize.TokenizerIterBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.tokenize.TokenizerIterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tokenize.TokenizerIterBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.pegparser.tokenizer.CodePoints;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import com.oracle.graal.python.pegparser.tokenizer.Tokenizer;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTokenizerIter})
public final class TokenizerIterBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TokenizerIterBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TokenizerIterBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        private static final TruffleString T_EOF = PythonUtils.tsLiteral("EOF");
        private static final CodePoints CP_LF = CodePoints.fromBuffer(new int[]{10}, 0, 1);
        private static final CodePoints CP_CRLF = CodePoints.fromBuffer(new int[]{13, 10}, 0, 2);

        NextNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PTuple next(PTokenizerIter self, @Bind Node inliningTarget, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayUTF32Node, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            Token token;
            if (self.isDone()) {
                throw raiseNode.raiseStopIteration(inliningTarget, T_EOF);
            }
            EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
            Node encapsulatingNode = encapsulating.set(inliningTarget);
            try {
                token = self.getNextToken();
            }
            finally {
                encapsulating.set(encapsulatingNode);
            }
            CodePoints tokenCp = self.getTokenCodePoints(token);
            int type = token.type;
            boolean isTrailingToken = false;
            if (type == 0 || type == 6 && self.tokenizer.getDone() == Tokenizer.StatusCode.EOF) {
                isTrailingToken = true;
            }
            TruffleString line = self.tokenizer.isExtraTokens() && isTrailingToken ? PythonUtils.TS_ENCODING.getEmpty() : self.getLine(token, fromIntArrayUTF32Node, switchEncodingNode);
            int startLine = token.sourceRange.startLine;
            int endLine = token.sourceRange.endLine;
            int startColumn = token.sourceRange.startColumn;
            int endColumn = token.sourceRange.endColumn;
            if (token.type == 4) {
                --endColumn;
            }
            if (self.tokenizer.isExtraTokens()) {
                if (isTrailingToken) {
                    ++startLine;
                    ++endLine;
                    startColumn = 0;
                    endColumn = 0;
                }
                if (type > 6 && type < 55) {
                    type = 55;
                } else if (type == 57 || type == 56) {
                    type = 1;
                } else if (type == 4) {
                    tokenCp = !self.tokenizer.isImplicitNewline() ? (!tokenCp.isEmpty() && tokenCp.get(0) == 13 ? CP_CRLF : CP_LF) : CodePoints.EMPTY;
                    ++endColumn;
                } else if (type == 65 && self.tokenizer.isImplicitNewline()) {
                    tokenCp = CodePoints.EMPTY;
                }
            } else if (type == 5 || type == 6) {
                startColumn = -1;
                endColumn = -1;
            } else if (type == 4) {
                tokenCp = CodePoints.EMPTY;
            }
            return PFactory.createTuple(language, new Object[]{type, switchEncodingNode.execute((AbstractTruffleString)fromIntArrayUTF32Node.execute(tokenCp.getBuffer(), tokenCp.getOffset(), tokenCp.getLength()), PythonUtils.TS_ENCODING), PFactory.createTuple(language, new Object[]{startLine, startColumn}), PFactory.createTuple(language, new Object[]{endLine, endColumn}), line});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static PTokenizerIter iter(PTokenizerIter self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="TokenizerIter", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$cls", "readline"}, keywordOnlyNames={"extra_tokens", "encoding"})
    @ArgumentsClinic(value={@ArgumentClinic(name="extra_tokens", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true"), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, useDefaultForNone=true, defaultValue="PNone.NONE")})
    @GenerateNodeFactory
    static abstract class TokenizerIterNode
    extends PythonQuaternaryClinicBuiltinNode {
        TokenizerIterNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TokenizerIterBuiltinsClinicProviders.TokenizerIterNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTokenizerIter tokenizerIterStr(Object cls, Object readline, boolean extraTokens, PNone encoding, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            Supplier inputSupplier = () -> {
                TruffleString line;
                Object o;
                try {
                    o = CallNode.executeUncached(readline, new Object[0]);
                }
                catch (PException e) {
                    e.expectUncached(PythonBuiltinClassType.StopIteration);
                    return null;
                }
                try {
                    line = CastToTruffleStringNode.executeUncached(o);
                }
                catch (CannotCastException e) {
                    throw PRaiseNode.raiseStatic(null, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_STRING, "readline()", o);
                }
                return TokenizerIterNode.getCodePoints(line);
            };
            return PFactory.createTokenizerIter(language, cls, getInstanceShape.execute(cls), inputSupplier, extraTokens);
        }

        @Specialization
        static PTokenizerIter tokenizerIterBytes(Object cls, Object readline, boolean extraTokens, TruffleString encoding, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            Charset charset;
            try {
                charset = TokenizerIterNode.getCharset(Tokenizer.getNormalName(encoding.toJavaStringUncached()));
            }
            catch (Exception e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.LookupError, ErrorMessages.UNKNOWN_ENCODING, encoding);
            }
            Supplier inputSupplier = () -> {
                int len;
                byte[] bytes;
                Object buffer;
                Object o;
                try {
                    o = CallNode.executeUncached(readline, new Object[0]);
                }
                catch (PException e) {
                    e.expectUncached(PythonBuiltinClassType.StopIteration);
                    return null;
                }
                if (!PyBytesCheckNode.executeUncached(o)) {
                    throw PRaiseNode.raiseStatic(null, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NONBYTES, "readline()", o);
                }
                try {
                    buffer = PythonBufferAcquireLibrary.getUncached().acquireReadonly(o);
                }
                catch (PException e) {
                    throw PRaiseNode.raiseStatic(null, PythonErrorType.TypeError, ErrorMessages.EXPECTED_BYTESLIKE_GOT_P, o);
                }
                PythonBufferAccessLibrary bufferLib = PythonBufferAccessLibrary.getUncached();
                try {
                    bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                    len = bufferLib.getBufferLength(buffer);
                }
                finally {
                    bufferLib.release(buffer);
                }
                String line = charset.decode(ByteBuffer.wrap(bytes, 0, len)).toString();
                return TokenizerIterNode.getCodePoints(TruffleString.fromJavaStringUncached((String)line, (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            };
            return PFactory.createTokenizerIter(language, cls, getInstanceShape.execute(cls), inputSupplier, extraTokens);
        }

        @CompilerDirectives.TruffleBoundary
        private static Charset getCharset(String s) {
            return Charset.forName(s);
        }

        private static int[] getCodePoints(TruffleString ts) {
            int len = ts.codePointLengthUncached(PythonUtils.TS_ENCODING);
            if (len == 0) {
                return null;
            }
            int[] res = new int[len];
            int i = 0;
            TruffleStringIterator it = ts.createCodePointIteratorUncached(PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                res[i++] = it.nextUncached(PythonUtils.TS_ENCODING);
            }
            return res;
        }
    }
}

