/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.settings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.TableModelEditor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.debugger.settings.PySteppingFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerSteppingConfigurableUi
implements ConfigurableUi<PyDebuggerSettings> {
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{new EnabledColumn(), new FilterColumn()};
    private JPanel myPanel;
    private JPanel mySteppingPanel;
    private JBCheckBox myLibrariesFilterCheckBox;
    private JBCheckBox myStepFilterEnabledCheckBox;
    private JBCheckBox myAlwaysDoSmartStepIntoCheckBox;
    private TableModelEditor<PySteppingFilter> myPySteppingFilterEditor;

    public PyDebuggerSteppingConfigurableUi() {
        this.$$$setupUI$$$();
        this.myStepFilterEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent e) {
                PyDebuggerSteppingConfigurableUi.this.myPySteppingFilterEditor.enabled(PyDebuggerSteppingConfigurableUi.this.myStepFilterEnabledCheckBox.isSelected());
            }
        });
    }

    private void createUIComponents() {
        DialogEditor itemEditor = new DialogEditor();
        this.myPySteppingFilterEditor = new TableModelEditor(COLUMNS, (CollectionItemEditor)itemEditor, PyBundle.message("debugger.stepping.no.script.filters", new Object[0]));
        this.mySteppingPanel = new JPanel(new BorderLayout());
        this.mySteppingPanel.add(this.myPySteppingFilterEditor.createComponent());
    }

    public void reset(@NotNull PyDebuggerSettings settings) {
        if (settings == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(0);
        }
        this.myLibrariesFilterCheckBox.setSelected(settings.isLibrariesFilterEnabled());
        this.myStepFilterEnabledCheckBox.setSelected(settings.isSteppingFiltersEnabled());
        this.myAlwaysDoSmartStepIntoCheckBox.setSelected(settings.isAlwaysDoSmartStepInto());
        this.myPySteppingFilterEditor.reset(settings.getSteppingFilters());
        this.myPySteppingFilterEditor.enabled(this.myStepFilterEnabledCheckBox.isSelected());
    }

    public boolean isModified(@NotNull PyDebuggerSettings settings) {
        if (settings == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(1);
        }
        return this.myLibrariesFilterCheckBox.isSelected() != settings.isLibrariesFilterEnabled() || this.myStepFilterEnabledCheckBox.isSelected() != settings.isSteppingFiltersEnabled() || this.myAlwaysDoSmartStepIntoCheckBox.isSelected() != settings.isAlwaysDoSmartStepInto() || this.myPySteppingFilterEditor.isModified();
    }

    public void apply(@NotNull PyDebuggerSettings settings) {
        if (settings == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(2);
        }
        settings.setLibrariesFilterEnabled(this.myLibrariesFilterCheckBox.isSelected());
        settings.setSteppingFiltersEnabled(this.myStepFilterEnabledCheckBox.isSelected());
        settings.setAlwaysDoSmartStepIntoEnabled(this.myAlwaysDoSmartStepIntoCheckBox.isSelected());
        if (this.myPySteppingFilterEditor.isModified()) {
            settings.setSteppingFilters(this.myPySteppingFilterEditor.apply());
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.mySteppingPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myLibrariesFilterCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerSteppingConfigurableUi.class).getString("form.debugger.stepping.checkbox.text.do.not.step.into.library.scripts"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStepFilterEnabledCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerSteppingConfigurableUi.class).getString("form.debugger.stepping.do.not.step.into.scripts"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAlwaysDoSmartStepIntoCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHorizontalAlignment(2);
        jBCheckBox.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerSteppingConfigurableUi.class).getString("form.debugger.stepping.always.do.smart.step.into"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class DialogEditor
    implements TableModelEditor.DialogItemEditor<PySteppingFilter> {
        private DialogEditor() {
        }

        public PySteppingFilter clone(@NotNull PySteppingFilter item, boolean forInPlaceEditing) {
            if (item == null) {
                DialogEditor.$$$reportNull$$$0(0);
            }
            return new PySteppingFilter(item.isEnabled(), item.getFilter());
        }

        @NotNull
        public Class<PySteppingFilter> getItemClass() {
            return PySteppingFilter.class;
        }

        public void edit(@NotNull PySteppingFilter item, @NotNull Function<? super PySteppingFilter, ? extends PySteppingFilter> mutator, boolean isAdd) {
            String pattern;
            if (item == null) {
                DialogEditor.$$$reportNull$$$0(1);
            }
            if (mutator == null) {
                DialogEditor.$$$reportNull$$$0(2);
            }
            if ((pattern = Messages.showInputDialog((Component)PyDebuggerSteppingConfigurableUi.this.myPanel, (String)PyBundle.message("debugger.stepping.filter.specify.pattern", new Object[0]), (String)PyBundle.message("debugger.stepping.filter", new Object[0]), null, (String)item.getFilter(), (InputValidator)new NonEmptyInputValidator())) != null) {
                ((PySteppingFilter)mutator.fun((Object)item)).setFilter(pattern);
                PyDebuggerSteppingConfigurableUi.this.myPySteppingFilterEditor.getModel().fireTableDataChanged();
            }
        }

        public void applyEdited(@NotNull PySteppingFilter oldItem, @NotNull PySteppingFilter newItem) {
            if (oldItem == null) {
                DialogEditor.$$$reportNull$$$0(3);
            }
            if (newItem == null) {
                DialogEditor.$$$reportNull$$$0(4);
            }
            oldItem.setFilter(newItem.getFilter());
        }

        public boolean isUseDialogToAdd() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newItem";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi$DialogEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clone";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "edit";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyEdited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EnabledColumn
    extends TableModelEditor.EditableColumnInfo<PySteppingFilter, Boolean> {
        private EnabledColumn() {
        }

        @Nullable
        public Boolean valueOf(PySteppingFilter filter) {
            return filter.isEnabled();
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public void setValue(PySteppingFilter filter, Boolean value) {
            filter.setEnabled(value);
        }
    }

    private static class FilterColumn
    extends TableModelEditor.EditableColumnInfo<PySteppingFilter, String> {
        private FilterColumn() {
        }

        @Nullable
        public String valueOf(PySteppingFilter filter) {
            return filter.getFilter();
        }

        public void setValue(PySteppingFilter filter, String value) {
            filter.setFilter(value);
        }
    }
}

