"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.geometries = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_color_scale_1 = require("./get_color_scale");
var get_grid_full_height_1 = require("./get_grid_full_height");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_heatmap_table_1 = require("./get_heatmap_table");
var get_legend_items_labels_1 = require("./get_legend_items_labels");
var scenegraph_1 = require("./scenegraph");
var getDeselectedSeriesSelector = function (state) { return state.interactions.deselectedDataSeries; };
exports.geometries = create_selector_1.createCustomCachedSelector([
    get_heatmap_spec_1.getHeatmapSpecSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_heatmap_table_1.getHeatmapTableSelector,
    get_color_scale_1.getColorScale,
    get_legend_items_labels_1.getLegendItemsLabelsSelector,
    getDeselectedSeriesSelector,
    get_grid_full_height_1.getGridHeightParamsSelector,
], function (heatmapSpec, chartDimensions, settingSpec, heatmapTable, colorScale, legendItems, deselectedSeries, gridHeightParams) {
    var deselectedTicks = new Set(deselectedSeries.map(function (_a) {
        var specId = _a.specId;
        return Number(specId);
    }));
    var ticks = colorScale.ticks;
    var ranges = ticks.reduce(function (acc, d, i) {
        if (deselectedTicks.has(d)) {
            var rangeEnd = i + 1 === ticks.length ? null : ticks[i + 1];
            acc.push([d, rangeEnd]);
        }
        return acc;
    }, []);
    return heatmapSpec
        ? scenegraph_1.render(heatmapSpec, settingSpec, chartDimensions, heatmapTable, colorScale, ranges, gridHeightParams)
        : viewmodel_types_1.nullShapeViewModel();
});
//# sourceMappingURL=geometries.js.map