/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingContextUtils;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandLineProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import icons.OpenapiIcons;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenCommandLineOptions;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunAnythingMavenItem;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenPluginWithArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u001a\u0010\u000b\u001a\u0014 \r*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\f0\u0005\u00a2\u0006\u0002\b\fH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/maven/execution/MavenRunAnythingProvider;", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingCommandLineProvider;", "<init>", "()V", "getHelpCommand", "", "getHelpIcon", "Ljavax/swing/Icon;", "getHelpGroupTitle", "getIcon", "value", "getCompletionGroupTitle", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "getHelpCommandPlaceholder", "getMainListItem", "Lorg/jetbrains/idea/maven/execution/RunAnythingMavenItem;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "suggestCompletionVariants", "Lkotlin/sequences/Sequence;", "commandLine", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingCommandLineProvider$CommandLine;", "run", "", "getMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lcom/intellij/ide/actions/runAnything/RunAnythingContext;", "projectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "completeOptions", "isLongOpt", "completeBasicPhases", "completeCustomGoals", "Companion", "intellij.maven"})
public final class MavenRunAnythingProvider
extends RunAnythingCommandLineProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String HELP_COMMAND = "mvn";

    @NotNull
    public String getHelpCommand() {
        return HELP_COMMAND;
    }

    @NotNull
    public Icon getHelpIcon() {
        Icon icon = OpenapiIcons.RepositoryLibraryLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RepositoryLibraryLogo");
        return icon;
    }

    @NotNull
    public String getHelpGroupTitle() {
        return "Maven";
    }

    @NotNull
    public Icon getIcon(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Icon icon = OpenapiIcons.RepositoryLibraryLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RepositoryLibraryLogo");
        return icon;
    }

    public String getCompletionGroupTitle() {
        return RunnerBundle.message("popup.title.maven.goals", new Object[0]);
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        return "mvn <goals...> <options...>";
    }

    @NotNull
    public RunAnythingMavenItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new RunAnythingMavenItem(this.getCommand(value), this.getIcon(value));
    }

    @NotNull
    protected Sequence<String> suggestCompletionVariants(@NotNull DataContext dataContext, @NotNull RunAnythingCommandLineProvider.CommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Sequence basicPhasesVariants = SequencesKt.sorted(this.completeBasicPhases(commandLine));
        Sequence customGoalsVariants = SequencesKt.sorted(this.completeCustomGoals(dataContext, commandLine));
        Sequence longOptionsVariants = SequencesKt.sorted(this.completeOptions(commandLine, true));
        Sequence shortOptionsVariants = SequencesKt.sorted(this.completeOptions(commandLine, false));
        return StringsKt.startsWith$default((String)commandLine.getToComplete(), (String)"--", (boolean)false, (int)2, null) ? SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)longOptionsVariants, (Sequence)shortOptionsVariants), (Sequence)basicPhasesVariants), (Sequence)customGoalsVariants) : (StringsKt.startsWith$default((String)commandLine.getToComplete(), (String)"-", (boolean)false, (int)2, null) ? SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)shortOptionsVariants, (Sequence)longOptionsVariants), (Sequence)basicPhasesVariants), (Sequence)customGoalsVariants) : SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)basicPhasesVariants, (Sequence)customGoalsVariants), (Sequence)longOptionsVariants), (Sequence)shortOptionsVariants));
    }

    protected boolean run(@NotNull DataContext dataContext, @NotNull RunAnythingCommandLineProvider.CommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"fetchProject(...)");
        Project project2 = project;
        RunAnythingContext runAnythingContext = (RunAnythingContext)dataContext.getData(RunAnythingProviderBase.EXECUTING_CONTEXT);
        if (runAnythingContext == null) {
            runAnythingContext = (RunAnythingContext)new RunAnythingContext.ProjectContext(project2);
        }
        RunAnythingContext context2 = runAnythingContext;
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNull((Object)projectsManager);
        MavenProject mavenProject = this.getMavenProject(context2, projectsManager);
        Object object = mavenProject;
        if ((object == null || (object = ((MavenProject)object).getDirectory()) == null) && (object = RunAnythingContextUtils.getPath((RunAnythingContext)context2)) == null) {
            return false;
        }
        Object workingDirPath = object;
        Object object2 = mavenProject;
        if (object2 == null || (object2 = ((MavenProject)object2).getFile()) == null || (object2 = object2.getName()) == null) {
            object2 = "pom.xml";
        }
        Object pomFileName = object2;
        MavenExplicitProfiles mavenExplicitProfiles = projectsManager.getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"getExplicitProfiles(...)");
        MavenExplicitProfiles explicitProfiles = mavenExplicitProfiles;
        Collection collection = explicitProfiles.getEnabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledProfiles(...)");
        Collection enabledProfiles = collection;
        Collection collection2 = explicitProfiles.getDisabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDisabledProfiles(...)");
        Collection disabledProfiles = collection2;
        List goals = commandLine.getParameters();
        MavenRunnerParameters params = new MavenRunnerParameters(true, (String)workingDirPath, (String)pomFileName, goals, enabledProfiles, disabledProfiles);
        MavenRunner mavenRunner = MavenRunner.getInstance(project2);
        mavenRunner.run(params, mavenRunner.getSettings(), null);
        return true;
    }

    private final MavenProject getMavenProject(RunAnythingContext $this$getMavenProject, MavenProjectsManager projectsManager) {
        MavenProject mavenProject;
        RunAnythingContext runAnythingContext = $this$getMavenProject;
        if (runAnythingContext instanceof RunAnythingContext.ProjectContext) {
            List<MavenProject> list = projectsManager.getRootProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
            mavenProject = (MavenProject)CollectionsKt.firstOrNull(list);
        } else if (runAnythingContext instanceof RunAnythingContext.ModuleContext) {
            mavenProject = projectsManager.findProject(((RunAnythingContext.ModuleContext)$this$getMavenProject).getModule());
        } else if (runAnythingContext instanceof RunAnythingContext.RecentDirectoryContext) {
            mavenProject = null;
        } else if (runAnythingContext instanceof RunAnythingContext.BrowseRecentDirectoryContext) {
            mavenProject = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mavenProject;
    }

    private final Sequence<String> completeOptions(RunAnythingCommandLineProvider.CommandLine commandLine, boolean isLongOpt) {
        Collection<MavenCommandLineOptions.Option> collection = MavenCommandLineOptions.getAllOptions();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllOptions(...)");
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> MavenRunAnythingProvider.completeOptions$lambda$0(isLongOpt, arg_0)), arg_0 -> MavenRunAnythingProvider.completeOptions$lambda$1(commandLine, arg_0));
    }

    private final Sequence<String> completeBasicPhases(RunAnythingCommandLineProvider.CommandLine commandLine) {
        List list = MavenConstants.BASIC_PHASES;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"BASIC_PHASES");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> MavenRunAnythingProvider.completeBasicPhases$lambda$2(commandLine, arg_0));
    }

    private final Sequence<String> completeCustomGoals(DataContext dataContext, RunAnythingCommandLineProvider.CommandLine commandLine) {
        MavenProjectsManager projectsManager;
        RunAnythingContext context2;
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"fetchProject(...)");
        Project project2 = project;
        RunAnythingContext runAnythingContext = (RunAnythingContext)dataContext.getData(RunAnythingProvider.EXECUTING_CONTEXT);
        if (runAnythingContext == null) {
            runAnythingContext = context2 = (RunAnythingContext)new RunAnythingContext.ProjectContext(project2);
        }
        if (!(projectsManager = MavenProjectsManager.getInstance(project2)).isMavenizedProject()) {
            return SequencesKt.emptySequence();
        }
        Intrinsics.checkNotNull((Object)projectsManager);
        MavenProject mavenProject = this.getMavenProject(context2, projectsManager);
        if (mavenProject == null) {
            return SequencesKt.emptySequence();
        }
        MavenProject mavenProject2 = mavenProject;
        Path localRepository = projectsManager.getRepositoryPath();
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)mavenProject2.getDeclaredPluginInfos()), MavenRunAnythingProvider::completeCustomGoals$lambda$3), MavenRunAnythingProvider::completeCustomGoals$lambda$4), MavenRunAnythingProvider::completeCustomGoals$lambda$5), arg_0 -> MavenRunAnythingProvider.completeCustomGoals$lambda$6(commandLine, arg_0));
    }

    private static final String completeOptions$lambda$0(boolean $isLongOpt, MavenCommandLineOptions.Option it) {
        return it.getName($isLongOpt);
    }

    private static final boolean completeOptions$lambda$1(RunAnythingCommandLineProvider.CommandLine $commandLine, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$commandLine.contains(it);
    }

    private static final boolean completeBasicPhases$lambda$2(RunAnythingCommandLineProvider.CommandLine $commandLine, String it) {
        Intrinsics.checkNotNull((Object)it);
        return !$commandLine.contains(it);
    }

    private static final MavenPluginInfo completeCustomGoals$lambda$3(MavenPluginWithArtifact it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MavenArtifactUtil.readPluginInfo(it.getArtifact());
    }

    private static final Sequence completeCustomGoals$lambda$4(MavenPluginInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection<MavenPluginInfo.Mojo> collection = it.getMojos();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getMojos(...)");
        return CollectionsKt.asSequence((Iterable)collection);
    }

    private static final String completeCustomGoals$lambda$5(MavenPluginInfo.Mojo it) {
        return it.getDisplayName();
    }

    private static final boolean completeCustomGoals$lambda$6(RunAnythingCommandLineProvider.CommandLine $commandLine, String it) {
        Intrinsics.checkNotNull((Object)it);
        return !$commandLine.contains(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/execution/MavenRunAnythingProvider$Companion;", "", "<init>", "()V", "HELP_COMMAND", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

