/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detection;

import ai.grazie.detector.ChainLanguageDetector;
import ai.grazie.detector.DefaultLanguageDetectors;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import ai.grazie.utils.mpp.DataLoader;
import ai.grazie.utils.mpp.FromResourcesDataLoader;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.config.DetectionContext;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.utils.UtilsKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR?\u0010\u000b\u001a3\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010\u0012\u000e\u0012\f0\u0011\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\f\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/grazie/detection/LangDetector;", "", "<init>", "()V", "detector", "Lai/grazie/detector/ChainLanguageDetector;", "", "getDetector", "()Lai/grazie/detector/ChainLanguageDetector;", "detector$delegate", "Lkotlin/Lazy;", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lai/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "textLimit", "", "detectWithDetails", "textToDetect", "isReliable", "getLanguage", "Lai/grazie/nlp/langs/Language;", "text", "getLang", "Lcom/intellij/grazie/jlanguage/Lang;", "updateContext", "", "", "context", "Lcom/intellij/grazie/config/DetectionContext$Local;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangDetector.kt\ncom/intellij/grazie/detection/LangDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class LangDetector {
    @NotNull
    public static final LangDetector INSTANCE = new LangDetector();
    @NotNull
    private static final Lazy detector$delegate = LazyKt.lazy(LangDetector::detector_delegate$lambda$0);
    @NotNull
    private static final ConcurrentMap<Pair<String, Boolean>, ChainLanguageDetector.ChainDetectionResult> cache;
    private static final int textLimit = 1000;

    private LangDetector() {
    }

    private final ChainLanguageDetector<String> getDetector() {
        Lazy lazy = detector$delegate;
        return (ChainLanguageDetector)lazy.getValue();
    }

    private final ChainLanguageDetector.ChainDetectionResult detectWithDetails(String textToDetect, boolean isReliable) {
        if (!(textToDetect.length() <= 1000)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ChainLanguageDetector.ChainDetectionResult chainDetectionResult = cache.computeIfAbsent((Pair<String, Boolean>)TuplesKt.to((Object)textToDetect, (Object)isReliable), arg_0 -> LangDetector.detectWithDetails$lambda$2(LangDetector::detectWithDetails$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)chainDetectionResult, (String)"computeIfAbsent(...)");
        return chainDetectionResult;
    }

    @Nullable
    public final Language getLanguage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Language detected = this.detectWithDetails(StringsKt.take((String)text, (int)1000), false).getResult().getPreferred();
        return detected == Language.UNKNOWN ? null : detected;
    }

    @Nullable
    public final Lang getLang(@NotNull String text) {
        Lang lang;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Language language = this.getLanguage(text);
        if (language != null) {
            Object v1;
            block3: {
                Language language2 = language;
                boolean bl = false;
                Iterable iterable = GrazieConfig.Companion.get().getAvailableLanguages();
                for (Object t : iterable) {
                    Lang lang2 = (Lang)((Object)t);
                    boolean bl2 = false;
                    if (!lang2.equalsTo(language2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            lang = v1;
        } else {
            lang = null;
        }
        return lang;
    }

    public final void updateContext(@NotNull CharSequence text, @NotNull DetectionContext.Local context) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String textToDetect = ((Object)StringsKt.take((CharSequence)text, (int)1000)).toString();
        ChainLanguageDetector.ChainDetectionResult details = this.detectWithDetails(textToDetect, true);
        int wordsCount = ((Collection)StandardWordTokenizer.INSTANCE.words(textToDetect)).size();
        context.update(text.length(), wordsCount, details);
    }

    private static final ChainLanguageDetector detector_delegate$lambda$0() {
        return (ChainLanguageDetector)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ChainLanguageDetector<String>>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DefaultLanguageDetectors.INSTANCE.standardForLanguages(UtilsKt.toLinkedSet(Language.Companion.getAll()), (DataLoader)FromResourcesDataLoader.INSTANCE, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ChainLanguageDetector<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final ChainLanguageDetector.ChainDetectionResult detectWithDetails$lambda$1(Pair it) {
        return INSTANCE.getDetector().detectWithDetails(it.getFirst(), ((Boolean)it.getSecond()).booleanValue());
    }

    private static final ChainLanguageDetector.ChainDetectionResult detectWithDetails$lambda$2(Function1 $tmp0, Object p0) {
        return (ChainLanguageDetector.ChainDetectionResult)$tmp0.invoke(p0);
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        cache = concurrentMap;
    }
}

