/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.branch.GitBranchPair;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.update.UpdateExecution;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00050\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/update/GitUpdateExecutionProcess;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "updateConfig", "", "Lgit4idea/branch/GitBranchPair;", "updateMethod", "Lgit4idea/config/UpdateMethod;", "shouldSetAsUpstream", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/Map;Lgit4idea/config/UpdateMethod;Z)V", "execute", "", "getVcsRoots", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUpdateExecutionProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/GitUpdateExecutionProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1193#2,2:98\n1267#2,4:100\n*S KotlinDebug\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/GitUpdateExecutionProcess\n*L\n55#1:98,2\n55#1:100,4\n*E\n"})
public final class GitUpdateExecutionProcess {
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;
    @NotNull
    private final Map<GitRepository, GitBranchPair> updateConfig;
    @NotNull
    private final UpdateMethod updateMethod;
    private final boolean shouldSetAsUpstream;

    public GitUpdateExecutionProcess(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull Map<GitRepository, GitBranchPair> updateConfig, @NotNull UpdateMethod updateMethod, boolean shouldSetAsUpstream) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(updateConfig, (String)"updateConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)updateMethod), (String)"updateMethod");
        this.project = project;
        this.repositories = repositories;
        this.updateConfig = updateConfig;
        this.updateMethod = updateMethod;
        this.shouldSetAsUpstream = shouldSetAsUpstream;
    }

    public /* synthetic */ GitUpdateExecutionProcess(Project project, Collection collection, Map map2, UpdateMethod updateMethod, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(project, collection, map2, updateMethod, bl);
    }

    public final void execute() {
        if (this.updateConfig.isEmpty()) {
            VcsNotifier.getInstance((Project)this.project).notifyMinorWarning("git.update.nothing.to.update", "", GitBundle.message("update.process.nothing.to.update", new Object[0]));
            return;
        }
        Map<AbstractVcs, Collection<FilePath>> vcsToRoots = this.getVcsRoots(this.repositories);
        FilePath[] roots = (FilePath[])UtilKt.toArray((Collection)CollectionsKt.flatten((Iterable)vcsToRoots.values()), (Object[])new FilePath[0]);
        ProgressManager.getInstance().run((Task)new UpdateExecution(this.project, vcsToRoots, roots, this.updateConfig, this.updateMethod, this.shouldSetAsUpstream));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<AbstractVcs, Collection<FilePath>> getVcsRoots(Collection<? extends GitRepository> repositories) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = repositories;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            GitRepository repo2 = (GitRepository)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((Object)repo2.getVcs()), (Object)CollectionsKt.listOf((Object)VcsUtil.getFilePath((VirtualFile)repo2.getRoot())));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }
}

