/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.loader;

import com.google.gson.stream.JsonReader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.model.BuildTargetState;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.storage.BuildTargetSourcesState;

public final class JpsMetadataLoader {
    private static final Logger LOG = Logger.getInstance(JpsMetadataLoader.class);
    private final Path sourceStateFile;
    private final JpsServerClient client;

    public JpsMetadataLoader(@NotNull String projectPath, @NotNull JpsServerClient client) {
        if (projectPath == null) {
            JpsMetadataLoader.$$$reportNull$$$0(0);
        }
        if (client == null) {
            JpsMetadataLoader.$$$reportNull$$$0(1);
        }
        this.client = client;
        this.sourceStateFile = Utils.getDataStorageRoot(projectPath).toPath().resolve("target_sources_state.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<String, Map<String, BuildTargetState>> loadMetadataForCommit(@NotNull JpsNettyClient nettyClient, @NotNull String metadataId) {
        block21: {
            Path tmpFolder;
            Path metadataFile;
            if (nettyClient == null) {
                JpsMetadataLoader.$$$reportNull$$$0(2);
            }
            if (metadataId == null) {
                JpsMetadataLoader.$$$reportNull$$$0(3);
            }
            if ((metadataFile = this.client.downloadMetadataById(nettyClient, metadataId, tmpFolder = Path.of(PathManager.getTempPath(), new String[0]))) == null) {
                return null;
            }
            try {
                Map<String, Map<String, BuildTargetState>> map;
                block20: {
                    BufferedReader bufferedReader = Files.newBufferedReader(metadataFile);
                    try {
                        map = BuildTargetSourcesState.readJson(new JsonReader((Reader)bufferedReader));
                        if (bufferedReader == null) break block20;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOG.warn("Couldn't parse content of file " + String.valueOf(metadataFile), (Throwable)e);
                            break block21;
                        }
                    }
                    bufferedReader.close();
                }
                return map;
            }
            finally {
                try {
                    Files.deleteIfExists(metadataFile);
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Nullable
    Map<String, Map<String, BuildTargetState>> loadCurrentProjectMetadata() {
        Map<String, Map<String, BuildTargetState>> map;
        block9: {
            if (Files.notExists(this.sourceStateFile, new LinkOption[0])) {
                return null;
            }
            BufferedReader bufferedReader = Files.newBufferedReader(this.sourceStateFile);
            try {
                map = BuildTargetSourcesState.readJson(new JsonReader((Reader)bufferedReader));
                if (bufferedReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Couldn't parse current project metadata " + String.valueOf(this.sourceStateFile), (Throwable)e);
                    return null;
                }
            }
            bufferedReader.close();
        }
        return map;
    }

    void dropCurrentProjectMetadata() {
        try {
            Files.deleteIfExists(this.sourceStateFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nettyClient";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/cache/loader/JpsMetadataLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadMetadataForCommit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

