/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.graph;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u000eB\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/util/graph/DirectedGraph;", "T", "", "edges", "", "Lorg/jetbrains/kotlin/util/graph/DirectedGraph$Edge;", "<init>", "(Ljava/util/Set;)V", "getEdges", "()Ljava/util/Set;", "vertices", "getVertices", "toString", "", "Edge", "kotlin.base.util"})
public final class DirectedGraph<T> {
    @NotNull
    private final Set<Edge<T>> edges;
    @NotNull
    private final Set<T> vertices;

    public DirectedGraph(@NotNull Set<Edge<T>> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        this.edges = edges;
        this.vertices = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.edges), DirectedGraph::vertices$lambda$0));
    }

    @NotNull
    public final Set<Edge<T>> getEdges() {
        return this.edges;
    }

    @NotNull
    public final Set<T> getVertices() {
        return this.vertices;
    }

    @NotNull
    public String toString() {
        return "DirectedGraph(" + this.edges + ", " + this.vertices + ")";
    }

    private static final Iterable vertices$lambda$0(Edge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getFrom(), it.getTo()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/util/graph/DirectedGraph$Edge;", "T", "", "from", "to", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/util/graph/DirectedGraph$Edge;", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.util"})
    public static final class Edge<T> {
        private final T from;
        private final T to;

        public Edge(T from, T to2) {
            this.from = from;
            this.to = to2;
        }

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final Edge<T> copy(T from, T to2) {
            return new Edge<T>(from, to2);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = edge.from;
            }
            if ((n & 2) != 0) {
                object2 = edge.to;
            }
            return edge.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "Edge(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            int result2 = this.from == null ? 0 : this.from.hashCode();
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual(this.from, edge.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, edge.to);
        }
    }
}

