/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.implCommon.handlers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.KotlinCompletionCharFilter;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.idea.completion.implCommon.handlers.WithExpressionPrefixInsertHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0013\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/implCommon/handlers/CompletionCharInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionParameters;)V", "isJustTyping", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "element", "handleInsert", "", "item", "equals", "other", "", "hashCode", "", "kotlin.completion.impl.shared"})
@ApiStatus.Internal
public final class CompletionCharInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final CompletionParameters completionParameters;

    public CompletionCharInsertHandler(@NotNull CompletionParameters completionParameters) {
        Intrinsics.checkNotNullParameter((Object)completionParameters, (String)"completionParameters");
        this.completionParameters = completionParameters;
    }

    private final boolean isJustTyping(InsertionContext context, LookupElement element) {
        if (!this.completionParameters.isAutoPopup()) {
            return false;
        }
        String string = context.getDocument().getText(new TextRange(context.getStartOffset(), context.getTailOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String insertedText = string;
        return Intrinsics.areEqual((Object)insertedText, (Object)CompletionUtilsNoResolveKt.getUserDataDeep(element, KotlinCompletionCharFilter.Companion.getJUST_TYPING_PREFIX()));
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        item.handleInsert(context);
        if (context.shouldAddCompletionChar() && !this.isJustTyping(context, item)) {
            switch (context.getCompletionChar()) {
                case ',': {
                    WithTailInsertHandler.Companion.getCOMMA().postHandleInsert(context, item);
                    break;
                }
                case '=': {
                    WithTailInsertHandler.Companion.getEQ().postHandleInsert(context, item);
                    break;
                }
                case '!': {
                    new WithExpressionPrefixInsertHandler("!").postHandleInsert(context);
                    context.setAddCompletionChar(false);
                }
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.implCommon.handlers.CompletionCharInsertHandler");
        CompletionCharInsertHandler cfr_ignored_0 = (CompletionCharInsertHandler)other;
        return Intrinsics.areEqual((Object)this.completionParameters, (Object)((CompletionCharInsertHandler)other).completionParameters);
    }

    public int hashCode() {
        return this.completionParameters.hashCode();
    }
}

