/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Hash {
    public static final float FAST_LOAD_FACTOR = 0.5f;
    public static final int DEFAULT_INITIAL_SIZE = 16;

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, Hash.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private static long nextPowerOfTwo(long x) {
        return 1L << 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }
}

