# BSim Tutorial

BSim is a Ghidra plugin for finding structurally similar functions in (potentially large) collections of binaries.
It is based on Ghidra's decompiler and can find matches across compilers, architectures, and/or small changes to source code.

This tutorial demonstrates how create a small BSim database and walks through some typical use cases.

**Detailed information about BSim can be found in the "BSim" entry of the Ghidra Help**.

1. [Introduction to BSim](BSimTutorial_Intro.md)
1. [Starting Ghidra and Enabling BSim](BSimTutorial_Enabling.md)
1. [Creating and Populating a BSim Database from the GUI](BSimTutorial_Creating_Database_From_GUI.md)
1. [Basic BSim Queries](BSimTutorial_Basic_Queries.md)
1. [Ghidra from the Command Line](BSimTutorial_Ghidra_Command_Line.md)
1. [BSim from the Command Line](BSimTutorial_BSim_Command_Line.md)
1. [Evaluating Matches](BSimTutorial_Evaluating_Matches.md)
1. [From Matching Functions to Matching Executables](BSimTutorial_Exe_Results.md)
1. [Overview Queries](BSimTutorial_Overview_Queries.md)
1. [BSim Filters](BSimTutorial_Filters.md)
1. [Scripting and Visualization](BSimTutorial_Scripting.md)

Next Section: [Introduction to BSim](BSimTutorial_Intro.md)
