/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.CycleGroup;
import javax.swing.KeyStroke;

public class CycleGroupAction
extends CompositeEditorTableAction {
    private static final String GROUP_NAME = "3_DATA_EDITOR_ACTION";
    private CycleGroup cycleGroup;

    public CycleGroupAction(CompositeEditorProvider<?, ?> provider, CycleGroup cycleGroup) {
        super(provider, cycleGroup.getName());
        this.setMenuBarData(new MenuData(new String[]{"Cycle", cycleGroup.getName()}, null, GROUP_NAME));
        this.setPopupMenuData(new MenuData(new String[]{"Cycle", cycleGroup.getName()}, null, GROUP_NAME));
        this.cycleGroup = cycleGroup;
        this.getPopupMenuData().setParentMenuGroup(GROUP_NAME);
        this.initKeyStroke(cycleGroup.getDefaultKeyStroke());
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public CycleGroup getCycleGroup() {
        return this.cycleGroup;
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        this.model.cycleDataType(this.cycleGroup);
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry();
    }

    @Override
    public String getHelpName() {
        return "Cycle";
    }
}

